"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllBrowserFields = getAllBrowserFields;
exports.useFetchIndex = exports.getIndexFields = exports.getAllFieldsByName = void 0;
var _fp = require("lodash/fp");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _react = require("react");
var _build_browser_fields = require("../../../data_view_manager/utils/build_browser_fields");
var _kibana = require("../../lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../hooks/use_app_toasts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAllBrowserFields(browserFields) {
  let result = [];
  for (const namespace of Object.values(browserFields)) {
    if (namespace.fields) {
      const namespaceFields = Object.values(namespace.fields);
      result = result.concat(namespaceFields);
    }
  }
  return result;
}

/**
 * @deprecated use EcsFlat from `@kbn/ecs`
 * @param browserFields
 * @returns
 */
const getAllFieldsByName = exports.getAllFieldsByName = (0, _memoizeOne.default)(browserFields => (0, _fp.keyBy)('name', getAllBrowserFields(browserFields)), (newArgs, lastArgs) => newArgs[0] === lastArgs[0]);
const getIndexFields = exports.getIndexFields = (0, _memoizeOne.default)((title, fields) => fields && fields.length > 0 ? {
  fields: fields.map(field => (0, _fp.pick)(['name', 'searchable', 'type', 'aggregatable', 'esTypes', 'subType', 'conflictDescriptions'], field)),
  title
} : {
  fields: [],
  title
}, (newArgs, lastArgs) => newArgs[0] === lastArgs[0] && newArgs[1].length === lastArgs[1].length);
const DEFAULT_BROWSER_FIELDS = {};
const DEFAULT_INDEX_PATTERNS = {
  fields: [],
  title: ''
};
/**
 * Independent index fields hook/request
 * returns state directly, no redux
 */
const useFetchIndex = (indexNames, onlyCheckIfIndicesExist = false, strategy = 'indexFields') => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const previousIndexesName = (0, _react.useRef)([]);
  const [state, setState] = (0, _react.useState)({
    browserFields: DEFAULT_BROWSER_FIELDS,
    indexes: indexNames,
    indexExists: true,
    indexPatterns: DEFAULT_INDEX_PATTERNS,
    dataView: undefined,
    loading: false
  });
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const indexFieldsSearch = (0, _react.useCallback)(iNames => {
    const asyncSearch = async () => {
      try {
        setState({
          ...state,
          loading: true
        });
        abortCtrl.current = new AbortController();
        const dv = await data.dataViews.create({
          title: iNames.join(','),
          allowNoIndex: true
        });
        const dataView = dv.toSpec();
        const browserFields = (0, _build_browser_fields.buildBrowserFields)(dv === null || dv === void 0 ? void 0 : dv.fields);
        previousIndexesName.current = dv.getIndexPattern().split(',');
        setState({
          loading: false,
          dataView,
          browserFields,
          indexes: dv.getIndexPattern().split(','),
          indexExists: dv.getIndexPattern().split(',').length > 0,
          indexPatterns: getIndexFields(dv.getIndexPattern(), dv.fields)
        });
      } catch (exc) {
        setState({
          browserFields: DEFAULT_BROWSER_FIELDS,
          indexes: indexNames,
          indexExists: true,
          indexPatterns: DEFAULT_INDEX_PATTERNS,
          dataView: undefined,
          loading: false
        });
        addError(exc === null || exc === void 0 ? void 0 : exc.message, {
          title: i18n.ERROR_INDEX_FIELDS_SEARCH
        });
      }
    };
    asyncSearch();
  }, [addError, data.dataViews, indexNames, state]);
  (0, _react.useEffect)(() => {
    if (!(0, _fp.isEmpty)(indexNames) && !(0, _fp.isEqual)(previousIndexesName.current, indexNames)) {
      indexFieldsSearch(indexNames);
    }
    return () => {
      abortCtrl.current.abort();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [indexNames, previousIndexesName]);
  return [state.loading, state];
};
exports.useFetchIndex = useFetchIndex;