"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEndpointPrivileges = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _kibana = require("../../../lib/kibana");
var _use_license = require("../../../hooks/use_license");
var _authz = require("../../../../../common/endpoint/service/authz");
var _security_solution_start_dependencies = require("./security_solution_start_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve the endpoint privileges for the current user.
 *
 * **NOTE:** Consider using `usePrivileges().endpointPrivileges` instead of this hook in order
 * to keep API calls to a minimum.
 */
const useEndpointPrivileges = () => {
  var _useSecuritySolutionS, _fleetServicesFromUse;
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  const user = (0, _kibana.useCurrentUser)();
  const kibanaServices = (0, _kibana.useKibana)().services;
  const fleetServicesFromUseKibana = kibanaServices.fleet;
  // The `fleetServicesFromPluginStart` will be defined when this hooks called from a component
  // that is being rendered under the Fleet context (UI extensions). The `fleetServicesFromUseKibana`
  // above will be `undefined` in this case.
  const fleetServicesFromPluginStart = (_useSecuritySolutionS = (0, _security_solution_start_dependencies.useSecuritySolutionStartDependencies)()) === null || _useSecuritySolutionS === void 0 ? void 0 : _useSecuritySolutionS.fleet;
  const fleetAuthz = (_fleetServicesFromUse = fleetServicesFromUseKibana === null || fleetServicesFromUseKibana === void 0 ? void 0 : fleetServicesFromUseKibana.authz) !== null && _fleetServicesFromUse !== void 0 ? _fleetServicesFromUse : fleetServicesFromPluginStart === null || fleetServicesFromPluginStart === void 0 ? void 0 : fleetServicesFromPluginStart.authz;
  const licenseService = (0, _use_license.useLicense)();
  const [userRolesCheckDone, setUserRolesCheckDone] = (0, _react.useState)(false);
  const [userRoles, setUserRoles] = (0, _react.useState)([]);
  const privileges = (0, _react.useMemo)(() => {
    const loading = !userRolesCheckDone || !user;
    const privilegeList = Object.freeze({
      loading,
      ...(!loading && fleetAuthz && !(0, _lodash.isEmpty)(user) ? (0, _authz.calculateEndpointAuthz)(licenseService, fleetAuthz, userRoles) : (0, _authz.getEndpointAuthzInitialState)())
    });
    return privilegeList;
  }, [userRolesCheckDone, user, fleetAuthz, licenseService, userRoles]);

  // get user roles
  (0, _react.useEffect)(() => {
    (async () => {
      if (user && isMounted()) {
        setUserRoles(user === null || user === void 0 ? void 0 : user.roles);
        setUserRolesCheckDone(true);
      }
    })();
  }, [isMounted, user]);
  return privileges;
};
exports.useEndpointPrivileges = useEndpointPrivileges;