"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_ALERT_TAGS_SUCCESS_TOAST = exports.UPDATE_ALERT_TAGS_FAILURE = exports.UPDATE_ALERT_STATUS_FAILED_DETAILED = exports.UPDATE_ALERT_STATUS_FAILED = exports.UPDATE_ALERT_ASSIGNEES_SUCCESS_TOAST = exports.UPDATE_ALERT_ASSIGNEES_FAILURE = exports.SELECT_ALL_ENTITIES = exports.SELECTED_ENTITIES = exports.REMOVE_ALERT_ASSIGNEES_CONTEXT_MENU_TITLE = exports.OPENED_ALERT_SUCCESS_TOAST = exports.OPENED_ALERT_FAILED_TOAST = exports.CLOSING_REASON_TRUE_POSITIVE = exports.CLOSING_REASON_OTHER = exports.CLOSING_REASON_FALSE_POSITIVE = exports.CLOSING_REASON_DUPLICATE = exports.CLOSING_REASON_CLOSE_WITHOUT_REASON = exports.CLOSING_REASON_BENIGN_POSITIVE = exports.CLOSING_REASON_AUTOMATED_CLOSURE = exports.CLOSED_ALERT_SUCCESS_TOAST = exports.CLOSED_ALERT_FAILED_TOAST = exports.CLEAR_SELECTION = exports.BULK_ACTION_OPEN_SELECTED = exports.BULK_ACTION_FAILED_SINGLE_ALERT = exports.BULK_ACTION_CLOSE_SELECTED = exports.BULK_ACTION_ACKNOWLEDGED_SELECTED = exports.ALERT_TAGS_MENU_SEARCH_PLACEHOLDER = exports.ALERT_TAGS_MENU_SEARCH_NO_TAGS_FOUND = exports.ALERT_TAGS_MENU_EMPTY = exports.ALERT_TAGS_CONTEXT_MENU_ITEM_TOOLTIP_INFO = exports.ALERT_TAGS_CONTEXT_MENU_ITEM_TITLE = exports.ALERT_TAGS_APPLY_BUTTON_MESSAGE = exports.ALERT_CLOSING_REASON_MENU_TITLE = exports.ALERT_CLOSING_REASON_BUTTON_MESSAGE = exports.ALERT_ASSIGNEES_CONTEXT_MENU_ITEM_TITLE = exports.ACKNOWLEDGED_ALERT_SUCCESS_TOAST = exports.ACKNOWLEDGED_ALERT_FAILED_TOAST = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_TYPE_PLURAL = (entityType, count) => {
  switch (entityType) {
    case _securitysolutionDataTable.TableEntityType.alert:
      {
        return _i18n.i18n.translate('xpack.securitySolution.toolbar.bulkActions.entityAlerts', {
          values: {
            count
          },
          defaultMessage: '{count, plural, =1 {alert} other {alerts}}'
        });
      }
    case _securitysolutionDataTable.TableEntityType.event:
      {
        return _i18n.i18n.translate('xpack.securitySolution.toolbar.bulkActions.entityEvents', {
          values: {
            count
          },
          defaultMessage: '{count, plural, =1 {event} other {events}}'
        });
      }
    case _securitysolutionDataTable.TableEntityType.session:
      {
        return _i18n.i18n.translate('xpack.securitySolution.toolbar.bulkActions.entitySessions', {
          values: {
            count
          },
          defaultMessage: '{count, plural, =1 {session} other {sessions}}'
        });
      }
  }
};
const SELECT_ALL_ENTITIES = (entityType, totalFormatted, total) => _i18n.i18n.translate('xpack.securitySolution.toolbar.bulkActions.selectAllEntitiesTitle', {
  values: {
    entityPlural: ENTITY_TYPE_PLURAL(entityType, total),
    totalFormatted,
    total
  },
  defaultMessage: 'Select {total, plural, =1 {} other {all}} {totalFormatted} {entityPlural}'
});
exports.SELECT_ALL_ENTITIES = SELECT_ALL_ENTITIES;
const SELECTED_ENTITIES = (entityType, totalFormatted, total) => _i18n.i18n.translate('xpack.securitySolution.toolbar.bulkActions.selectedEntitiesTitle', {
  values: {
    entityPlural: ENTITY_TYPE_PLURAL(entityType, total),
    totalFormatted
  },
  defaultMessage: 'Selected {totalFormatted} {entityPlural}'
});
exports.SELECTED_ENTITIES = SELECTED_ENTITIES;
const CLEAR_SELECTION = exports.CLEAR_SELECTION = _i18n.i18n.translate('xpack.securitySolution.toolbar.bulkActions.clearSelectionTitle', {
  defaultMessage: 'Clear selection'
});
const UPDATE_ALERT_STATUS_FAILED = conflicts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertStatusFailed', {
  values: {
    conflicts
  },
  defaultMessage: 'Failed to update { conflicts } {conflicts, plural, =1 {alert} other {alerts}}.'
});
exports.UPDATE_ALERT_STATUS_FAILED = UPDATE_ALERT_STATUS_FAILED;
const UPDATE_ALERT_STATUS_FAILED_DETAILED = (updated, conflicts) => _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertStatusFailedDetailed', {
  values: {
    updated,
    conflicts
  },
  defaultMessage: `{ updated } {updated, plural, =1 {alert was} other {alerts were}} updated successfully, but { conflicts } failed to update
         because { conflicts, plural, =1 {it was} other {they were}} already being modified.`
});
exports.UPDATE_ALERT_STATUS_FAILED_DETAILED = UPDATE_ALERT_STATUS_FAILED_DETAILED;
const CLOSED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.closedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully closed {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.CLOSED_ALERT_SUCCESS_TOAST = CLOSED_ALERT_SUCCESS_TOAST;
const OPENED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.openedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully opened {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.OPENED_ALERT_SUCCESS_TOAST = OPENED_ALERT_SUCCESS_TOAST;
const ACKNOWLEDGED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.acknowledgedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully marked {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}} as acknowledged.'
});
exports.ACKNOWLEDGED_ALERT_SUCCESS_TOAST = ACKNOWLEDGED_ALERT_SUCCESS_TOAST;
const CLOSED_ALERT_FAILED_TOAST = exports.CLOSED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.bulkActions.closedAlertFailedToastMessage', {
  defaultMessage: 'Failed to close alert(s).'
});
const OPENED_ALERT_FAILED_TOAST = exports.OPENED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.bulkActions.openedAlertFailedToastMessage', {
  defaultMessage: 'Failed to open alert(s)'
});
const ACKNOWLEDGED_ALERT_FAILED_TOAST = exports.ACKNOWLEDGED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.bulkActions.acknowledgedAlertFailedToastMessage', {
  defaultMessage: 'Failed to mark alert(s) as acknowledged'
});
const BULK_ACTION_FAILED_SINGLE_ALERT = exports.BULK_ACTION_FAILED_SINGLE_ALERT = _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertStatusFailedSingleAlert', {
  defaultMessage: 'Failed to update alert because it was already being modified.'
});
const BULK_ACTION_OPEN_SELECTED = exports.BULK_ACTION_OPEN_SELECTED = _i18n.i18n.translate('xpack.securitySolution.bulkActions.openSelectedTitle', {
  defaultMessage: 'Mark as open'
});
const BULK_ACTION_ACKNOWLEDGED_SELECTED = exports.BULK_ACTION_ACKNOWLEDGED_SELECTED = _i18n.i18n.translate('xpack.securitySolution.bulkActions.acknowledgedSelectedTitle', {
  defaultMessage: 'Mark as acknowledged'
});
const BULK_ACTION_CLOSE_SELECTED = exports.BULK_ACTION_CLOSE_SELECTED = _i18n.i18n.translate('xpack.securitySolution.bulkActions.closeSelectedTitle', {
  defaultMessage: 'Mark as closed'
});
const UPDATE_ALERT_TAGS_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertTagsSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully updated tags for {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.UPDATE_ALERT_TAGS_SUCCESS_TOAST = UPDATE_ALERT_TAGS_SUCCESS_TOAST;
const UPDATE_ALERT_TAGS_FAILURE = exports.UPDATE_ALERT_TAGS_FAILURE = _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertTagsFailedToastMessage', {
  defaultMessage: 'Failed to update alert tags.'
});
const ALERT_TAGS_MENU_SEARCH_PLACEHOLDER = exports.ALERT_TAGS_MENU_SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.bulkActions.alertTagsMenuSearchPlaceholderMessage', {
  defaultMessage: 'Search tags'
});
const ALERT_TAGS_MENU_SEARCH_NO_TAGS_FOUND = exports.ALERT_TAGS_MENU_SEARCH_NO_TAGS_FOUND = _i18n.i18n.translate('xpack.securitySolution.bulkActions.alertTagsMenuSearchNoTagsFoundMessage', {
  defaultMessage: 'No tags match current search'
});
const ALERT_TAGS_MENU_EMPTY = exports.ALERT_TAGS_MENU_EMPTY = _i18n.i18n.translate('xpack.securitySolution.bulkActions.alertTagsMenuEmptyMessage', {
  defaultMessage: 'No alert tag options exist, add tag options in Kibana Advanced Settings.'
});
const ALERT_TAGS_APPLY_BUTTON_MESSAGE = exports.ALERT_TAGS_APPLY_BUTTON_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.bulkActions.alertTagsApplyButtonMessage', {
  defaultMessage: 'Apply tags'
});
const ALERT_TAGS_CONTEXT_MENU_ITEM_TITLE = exports.ALERT_TAGS_CONTEXT_MENU_ITEM_TITLE = _i18n.i18n.translate('xpack.securitySolution.bulkActions.alertTagsContextMenuItemTitle', {
  defaultMessage: 'Apply alert tags'
});
const ALERT_TAGS_CONTEXT_MENU_ITEM_TOOLTIP_INFO = exports.ALERT_TAGS_CONTEXT_MENU_ITEM_TOOLTIP_INFO = _i18n.i18n.translate('xpack.securitySolution.bulkActions.alertTagsContextMenuItemTooltip', {
  defaultMessage: 'Change alert tag options in Kibana Advanced Settings.'
});
const UPDATE_ALERT_ASSIGNEES_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertAssigneesSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully updated assignees for {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.UPDATE_ALERT_ASSIGNEES_SUCCESS_TOAST = UPDATE_ALERT_ASSIGNEES_SUCCESS_TOAST;
const UPDATE_ALERT_ASSIGNEES_FAILURE = exports.UPDATE_ALERT_ASSIGNEES_FAILURE = _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertAssigneesFailedToastMessage', {
  defaultMessage: 'Failed to update alert assignees.'
});
const ALERT_ASSIGNEES_CONTEXT_MENU_ITEM_TITLE = exports.ALERT_ASSIGNEES_CONTEXT_MENU_ITEM_TITLE = _i18n.i18n.translate('xpack.securitySolution.bulkActions.alertAssigneesContextMenuItemTitle', {
  defaultMessage: 'Assign alert'
});
const REMOVE_ALERT_ASSIGNEES_CONTEXT_MENU_TITLE = exports.REMOVE_ALERT_ASSIGNEES_CONTEXT_MENU_TITLE = _i18n.i18n.translate('xpack.securitySolution.bulkActions.removeAlertAssignessContextMenuTitle', {
  defaultMessage: 'Unassign alert'
});
const ALERT_CLOSING_REASON_MENU_TITLE = exports.ALERT_CLOSING_REASON_MENU_TITLE = _i18n.i18n.translate('xpack.securitySolution.bulkActions.alertClosingReason.MenuTitle', {
  defaultMessage: 'Reason for closing'
});
const ALERT_CLOSING_REASON_BUTTON_MESSAGE = exports.ALERT_CLOSING_REASON_BUTTON_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.bulkActions.alertClosingReason.ButtonMessage', {
  defaultMessage: 'Close alert'
});
const CLOSING_REASON_DUPLICATE = exports.CLOSING_REASON_DUPLICATE = _i18n.i18n.translate('xpack.securitySolution.defaultAlertClosingReason.duplicate', {
  defaultMessage: 'Duplicate'
});
const CLOSING_REASON_FALSE_POSITIVE = exports.CLOSING_REASON_FALSE_POSITIVE = _i18n.i18n.translate('xpack.securitySolution.defaultAlertClosingReason.falsePositive', {
  defaultMessage: 'False Positive'
});
const CLOSING_REASON_CLOSE_WITHOUT_REASON = exports.CLOSING_REASON_CLOSE_WITHOUT_REASON = _i18n.i18n.translate('xpack.securitySolution.defaultAlertClosingReason.CloseWithoutReason', {
  defaultMessage: 'Close without reason'
});
const CLOSING_REASON_TRUE_POSITIVE = exports.CLOSING_REASON_TRUE_POSITIVE = _i18n.i18n.translate('xpack.securitySolution.defaultAlertClosingReason.true_positive', {
  defaultMessage: 'True positive'
});
const CLOSING_REASON_BENIGN_POSITIVE = exports.CLOSING_REASON_BENIGN_POSITIVE = _i18n.i18n.translate('xpack.securitySolution.defaultAlertClosingReason.benign_positive', {
  defaultMessage: 'Benign positive'
});
const CLOSING_REASON_AUTOMATED_CLOSURE = exports.CLOSING_REASON_AUTOMATED_CLOSURE = _i18n.i18n.translate('xpack.securitySolution.defaultAlertClosingReason.automated_closure', {
  defaultMessage: 'Automated closure'
});
const CLOSING_REASON_OTHER = exports.CLOSING_REASON_OTHER = _i18n.i18n.translate('xpack.securitySolution.defaultAlertClosingReason.other', {
  defaultMessage: 'Other'
});