"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlStateQueryParams = exports.useGetUrlStateQueryParams = void 0;
var _react = require("react");
var _global_query_string = require("../../utils/global_query_string");
var _links_hooks = require("../../links/links_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUrlStateQueryParams = pageName => {
  const getUrlStateQueryParams = useGetUrlStateQueryParams();
  const urlStateQueryParams = (0, _react.useMemo)(() => getUrlStateQueryParams(pageName), [getUrlStateQueryParams, pageName]);
  return urlStateQueryParams;
};
exports.useUrlStateQueryParams = useUrlStateQueryParams;
const useGetUrlStateQueryParams = () => {
  const globalQueryString = (0, _global_query_string.useGlobalQueryString)();
  const getLinkInfo = (0, _links_hooks.useGetLinkInfo)();
  const getUrlStateQueryParams = (0, _react.useCallback)(pageName => {
    var _getLinkInfo;
    const {
      skipUrlState = false
    } = (_getLinkInfo = getLinkInfo(pageName)) !== null && _getLinkInfo !== void 0 ? _getLinkInfo : {};
    return !skipUrlState && globalQueryString ? `?${globalQueryString}` : '';
  }, [getLinkInfo, globalQueryString]);
  return getUrlStateQueryParams;
};
exports.useGetUrlStateQueryParams = useGetUrlStateQueryParams;