"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecuritySolutionNavigation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _kibana = require("../../../lib/kibana");
var _breadcrumbs = require("../breadcrumbs");
var _security_side_nav = require("../security_side_nav");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/navigation/use_security_solution_navigation/use_security_solution_navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const translatedNavTitle = _i18n.i18n.translate('xpack.securitySolution.navigation.mainLabel', {
  defaultMessage: 'Security'
});
const useSecuritySolutionNavigation = () => {
  const {
    chrome
  } = (0, _kibana.useKibana)().services;
  const chromeStyle$ = (0, _react.useMemo)(() => chrome.getChromeStyle$(), [chrome]);
  const chromeStyle = (0, _useObservable.default)(chromeStyle$, undefined);
  (0, _breadcrumbs.useBreadcrumbsNav)();
  if (chromeStyle === undefined) {
    return undefined; // wait for chromeStyle to be initialized
  }
  if (chromeStyle === 'project') {
    // new shared-ux 'project' navigation enabled, return null to disable the 'classic' navigation
    return null;
  }
  return {
    canBeCollapsed: true,
    name: translatedNavTitle,
    icon: 'logoSecurity',
    children: /*#__PURE__*/_react.default.createElement(_security_side_nav.SecuritySideNav, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 15
      }
    }),
    closeFlyoutButtonPosition: 'inside'
  };
};
exports.useSecuritySolutionNavigation = useSecuritySolutionNavigation;