"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserNameFromEntity = exports.convertAnomaliesToUsers = void 0;
var _get_user_name_from_influencers = require("../influencers/get_user_name_from_influencers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertAnomaliesToUsers = (anomalies, jobNameById, userName) => {
  if (anomalies == null) {
    return [];
  } else {
    return anomalies.anomalies.reduce((accum, item) => {
      if (getUserNameFromEntity(item, userName)) {
        var _jobNameById$item$job;
        return [...accum, {
          userName: item.entityValue,
          jobName: (_jobNameById$item$job = jobNameById[item.jobId]) !== null && _jobNameById$item$job !== void 0 ? _jobNameById$item$job : item.jobId,
          anomaly: item
        }];
      } else {
        const userNameFromInfluencers = (0, _get_user_name_from_influencers.getUserNameFromInfluencers)(item.influencers, userName);
        if (userNameFromInfluencers != null) {
          var _jobNameById$item$job2;
          return [...accum, {
            userName: userNameFromInfluencers,
            jobName: (_jobNameById$item$job2 = jobNameById[item.jobId]) !== null && _jobNameById$item$job2 !== void 0 ? _jobNameById$item$job2 : item.jobId,
            anomaly: item
          }];
        } else {
          return accum;
        }
      }
    }, []);
  }
};
exports.convertAnomaliesToUsers = convertAnomaliesToUsers;
const getUserNameFromEntity = (anomaly, userName) => {
  if (anomaly.entityName !== 'user.name') {
    return false;
  } else if (userName == null) {
    return true;
  } else {
    return anomaly.entityValue === userName;
  }
};
exports.getUserNameFromEntity = getUserNameFromEntity;