"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLocalStorage = void 0;
var _react = require("react");
var _constants = require("../../../../common/constants");
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Reads and writes settings from local storage */
const useLocalStorage = ({
  defaultValue,
  key,
  plugin = _constants.APP_ID,
  isInvalidDefault
}) => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const [initialized, setInitialized] = (0, _react.useState)(false);
  const [_value, _setValue] = (0, _react.useState)(defaultValue);
  const readValueFromLocalStorage = (0, _react.useCallback)(() => {
    const value = storage.get(`${plugin}.${key}`);
    const valueAndDefaultTypesAreDifferent = typeof value !== typeof defaultValue;
    const valueIsInvalid = isInvalidDefault != null && isInvalidDefault(value);
    _setValue(valueAndDefaultTypesAreDifferent || valueIsInvalid ? defaultValue : value);
  }, [defaultValue, isInvalidDefault, key, plugin, storage]);
  const setValue = (0, _react.useCallback)(value => {
    if (typeof value === 'function') {
      const updater = value;
      _setValue(prevValue => {
        const newValue = updater(prevValue);
        storage.set(`${plugin}.${key}`, newValue);
        return newValue;
      });
    } else {
      storage.set(`${plugin}.${key}`, value);
      _setValue(value);
    }
  }, [key, plugin, storage]);
  (0, _react.useEffect)(() => {
    if (!initialized) {
      readValueFromLocalStorage();
      setInitialized(true);
    }
  }, [initialized, readValueFromLocalStorage]);
  return [_value, setValue, setInitialized];
};
exports.useLocalStorage = useLocalStorage;