"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_DETAILS_FOR_ROW = exports.VIEW_DETAILS = exports.SEND_ALERT_TO_TIMELINE_FOR_ROW = exports.PIN_EVENT_FOR_ROW = exports.OPEN_SESSION_VIEW = exports.MORE_ACTIONS_FOR_ROW = exports.ADD_NOTES_FOR_ROW = exports.ACTION_INVESTIGATE_IN_RESOLVER_FOR_ROW = exports.ACTION_INVESTIGATE_IN_RESOLVER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_SESSION_VIEW = exports.OPEN_SESSION_VIEW = _i18n.i18n.translate('xpack.securitySolution.timeline.body.openSessionViewLabel', {
  defaultMessage: 'Open Session View'
});
const VIEW_DETAILS = exports.VIEW_DETAILS = _i18n.i18n.translate('xpack.securitySolution.hoverActions.viewDetailsAriaLabel', {
  defaultMessage: 'View details'
});
const VIEW_DETAILS_FOR_ROW = ({
  ariaRowindex,
  columnValues
}) => _i18n.i18n.translate('xpack.securitySolution.hoverActions.viewDetailsForRowAriaLabel', {
  values: {
    ariaRowindex,
    columnValues
  },
  defaultMessage: 'View details for the alert or event in row {ariaRowindex}, with columns {columnValues}'
});
exports.VIEW_DETAILS_FOR_ROW = VIEW_DETAILS_FOR_ROW;
const ACTION_INVESTIGATE_IN_RESOLVER = exports.ACTION_INVESTIGATE_IN_RESOLVER = _i18n.i18n.translate('xpack.securitySolution.hoverActions.investigateInResolverTooltip', {
  defaultMessage: 'Analyze event'
});
const ACTION_INVESTIGATE_IN_RESOLVER_FOR_ROW = ({
  ariaRowindex,
  columnValues
}) => _i18n.i18n.translate('xpack.securitySolution.hoverActions.investigateInResolverForRowAriaLabel', {
  values: {
    ariaRowindex,
    columnValues
  },
  defaultMessage: 'Analyze the alert or event in row {ariaRowindex}, with columns {columnValues}'
});
exports.ACTION_INVESTIGATE_IN_RESOLVER_FOR_ROW = ACTION_INVESTIGATE_IN_RESOLVER_FOR_ROW;
const SEND_ALERT_TO_TIMELINE_FOR_ROW = ({
  ariaRowindex,
  columnValues
}) => _i18n.i18n.translate('xpack.securitySolution.hoverActions.sendAlertToTimelineForRowAriaLabel', {
  values: {
    ariaRowindex,
    columnValues
  },
  defaultMessage: 'Send the alert in row {ariaRowindex} to timeline, with columns {columnValues}'
});
exports.SEND_ALERT_TO_TIMELINE_FOR_ROW = SEND_ALERT_TO_TIMELINE_FOR_ROW;
const ADD_NOTES_FOR_ROW = ({
  ariaRowindex,
  columnValues
}) => _i18n.i18n.translate('xpack.securitySolution.hoverActions.addNotesForRowAriaLabel', {
  values: {
    ariaRowindex,
    columnValues
  },
  defaultMessage: 'Add notes for the event in row {ariaRowindex} to timeline, with columns {columnValues}'
});
exports.ADD_NOTES_FOR_ROW = ADD_NOTES_FOR_ROW;
const PIN_EVENT_FOR_ROW = ({
  ariaRowindex,
  columnValues,
  isEventPinned
}) => _i18n.i18n.translate('xpack.securitySolution.hoverActions.pinEventForRowAriaLabel', {
  defaultMessage: '{isEventPinned, select, true {Unpin} other {Pin} } the event in row {ariaRowindex} to timeline, with columns {columnValues}',
  values: {
    ariaRowindex,
    columnValues,
    isEventPinned
  }
});
exports.PIN_EVENT_FOR_ROW = PIN_EVENT_FOR_ROW;
const MORE_ACTIONS_FOR_ROW = ({
  ariaRowindex,
  columnValues
}) => _i18n.i18n.translate('xpack.securitySolution.hoverActions.moreActionsForRowAriaLabel', {
  values: {
    ariaRowindex,
    columnValues
  },
  defaultMessage: 'Select more actions for the alert or event in row {ariaRowindex}, with columns {columnValues}'
});
exports.MORE_ACTIONS_FOR_ROW = MORE_ACTIONS_FOR_ROW;