"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointIsolateSuccess = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("./translations");
var _use_cases_from_alerts = require("../../../../detections/containers/detection_engine/alerts/use_cases_from_alerts");
var _links = require("../../links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/endpoint/host_isolation/isolate_success.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CasesAdditionalInfo = ({
  alertIdForCase
}) => {
  const {
    casesInfo
  } = (0, _use_cases_from_alerts.useCasesFromAlerts)({
    alertId: alertIdForCase
  });
  const caseCount = (0, _react.useMemo)(() => casesInfo.length, [casesInfo]);
  const casesList = (0, _react.useMemo)(() => casesInfo.map((caseInfo, index) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: caseInfo.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
      detailName: caseInfo.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.hostIsolation.placeholderCase",
      defaultMessage: "{caseName}",
      values: {
        caseName: caseInfo.title
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 15
      }
    })));
  }), [casesInfo]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, caseCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.hostIsolation.successfulIsolation.cases",
    defaultMessage: "This action has been attached to the following {caseCount, plural, one {case} other {cases}}:",
    values: {
      caseCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, casesList))));
};
const EndpointIsolateSuccess = exports.EndpointIsolateSuccess = /*#__PURE__*/(0, _react.memo)(({
  hostName,
  alertId,
  isolateAction = 'isolateHost',
  additionalInfo
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "check",
    color: "success",
    title: isolateAction === 'isolateHost' ? (0, _translations.GET_ISOLATION_SUCCESS_MESSAGE)(hostName) : (0, _translations.GET_UNISOLATION_SUCCESS_MESSAGE)(hostName),
    "data-test-subj": isolateAction === 'isolateHost' ? 'hostIsolateSuccessMessage' : 'hostUnisolateSuccessMessage',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, alertId !== undefined ? CasesAdditionalInfo({
    alertIdForCase: alertId
  }) : additionalInfo);
});
EndpointIsolateSuccess.displayName = 'EndpointIsolateSuccess';