"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIFY_TITLE = exports.UNIFY_DESCRIPTION = exports.SIEM_TITLE = exports.SIEM_HEADER = exports.SIEM_DESCRIPTION = exports.SIEM_CTA = exports.SIEM_CONTINUE = exports.SIEM_CARD_TITLE = exports.SIEM_CARD_DESCRIPTION = exports.ENDPOINT_TITLE = exports.ENDPOINT_DESCRIPTION = exports.CLOUD_CARD_TITLE = exports.CLOUD_CARD_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIEM_HEADER = exports.SIEM_HEADER = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.siem.header', {
  defaultMessage: 'Elastic Security'
});
const SIEM_TITLE = exports.SIEM_TITLE = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.siem.title', {
  defaultMessage: 'Security at the speed of Elastic'
});
const SIEM_DESCRIPTION = exports.SIEM_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.siem.desc', {
  defaultMessage: 'Elastic Security equips teams to prevent, detect, and respond to threats at cloud speed and scale — securing business operations with a unified, open platform.'
});
const SIEM_CTA = exports.SIEM_CTA = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.siem.cta', {
  defaultMessage: 'Add security integrations'
});
const SIEM_CONTINUE = exports.SIEM_CONTINUE = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.siem.continue', {
  defaultMessage: 'Continue without adding integrations'
});
const ENDPOINT_TITLE = exports.ENDPOINT_TITLE = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.endpoint.title', {
  defaultMessage: 'Endpoint security at scale'
});
const ENDPOINT_DESCRIPTION = exports.ENDPOINT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.endpoint.desc', {
  defaultMessage: 'Prevent, collect, detect and respond — all with Elastic Agent.'
});
const SIEM_CARD_TITLE = exports.SIEM_CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.siemCard.title', {
  defaultMessage: 'SIEM for the modern SOC'
});
const SIEM_CARD_DESCRIPTION = exports.SIEM_CARD_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.siemCard.desc', {
  defaultMessage: 'Detect, investigate, and respond to evolving threats in your environment.'
});
const CLOUD_CARD_TITLE = exports.CLOUD_CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.cloudCard.title', {
  defaultMessage: 'Cloud protection end-to-end'
});
const CLOUD_CARD_DESCRIPTION = exports.CLOUD_CARD_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.cloudCard.desc', {
  defaultMessage: 'Assess your Cloud Posture and protect your workloads from attacks.'
});
const UNIFY_TITLE = exports.UNIFY_TITLE = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.unify.title', {
  defaultMessage: 'Unify SIEM, endpoint security, and cloud security'
});
const UNIFY_DESCRIPTION = exports.UNIFY_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.getStarted.landingCards.box.unify.desc', {
  defaultMessage: 'Elastic Security modernizes security operations — enabling analytics across years of data, automating key processes, and protecting every host.'
});