"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilitiesFindingsDetailsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _securitySolutionDistributionBar = require("@kbn/security-solution-distribution-bar");
var _use_vulnerabilities_findings = require("@kbn/cloud-security-posture/src/hooks/use_vulnerabilities_findings");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _use_get_navigation_url_params = require("@kbn/cloud-security-posture/src/hooks/use_get_navigation_url_params");
var _use_get_severity_status_color = require("@kbn/cloud-security-posture/src/hooks/use_get_severity_status_color");
var _use_has_vulnerabilities = require("@kbn/cloud-security-posture/src/hooks/use_has_vulnerabilities");
var _fp = require("lodash/fp");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _constants = require("../../../flyout/csp_details/vulnerabilities_flyout/constants");
var _types = require("../../../../common/entity_analytics/types");
var _links = require("../../../common/components/links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cloud_security_posture/components/csp_details/vulnerabilities_findings_details_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_VALUE = '-';
const VulnerabilitiesFindingsDetailsTable = exports.VulnerabilitiesFindingsDetailsTable = /*#__PURE__*/(0, _react.memo)(({
  value,
  scopeId
}) => {
  const {
    getSeverityStatusColor
  } = (0, _use_get_severity_status_color.useGetSeverityStatusColor)();
  (0, _react.useEffect)(() => {
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.ENTITY_FLYOUT_EXPAND_VULNERABILITY_VIEW_VISITS);
  }, []);
  const [currentFilter, setCurrentFilter] = (0, _react.useState)('');
  const [sortField, setSortField] = (0, _react.useState)(_use_vulnerabilities_findings.VULNERABILITY_FINDING.SEVERITY);
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const sortFieldDirection = {};
  sortFieldDirection[sortField === 'score' ? 'vulnerability.score.base' : sortField] = sortDirection;
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const {
    data
  } = (0, _use_vulnerabilities_findings.useVulnerabilitiesFindings)({
    query: (0, _cloudSecurityPostureCommon.buildVulnerabilityEntityFlyoutPreviewQuery)('host.name', value, currentFilter),
    sort: [sortFieldDirection],
    enabled: true,
    pageSize: 1
  });
  const {
    counts
  } = (0, _use_has_vulnerabilities.useHasVulnerabilities)('host.name', value);
  const {
    critical = 0,
    high = 0,
    medium = 0,
    low = 0,
    none = 0
  } = counts || {};
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const findingsPagination = findings => {
    let pageOfItems;
    if (!pageIndex && !pageSize) {
      pageOfItems = findings;
    } else {
      const startIndex = pageIndex * pageSize;
      pageOfItems = findings === null || findings === void 0 ? void 0 : findings.slice(startIndex, Math.min(startIndex + pageSize, findings === null || findings === void 0 ? void 0 : findings.length));
    }
    return {
      pageOfItems,
      totalItemCount: findings === null || findings === void 0 ? void 0 : findings.length
    };
  };
  const {
    pageOfItems,
    totalItemCount
  } = findingsPagination((data === null || data === void 0 ? void 0 : data.rows) || []);
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount,
    pageSizeOptions: [10, 25, 100]
  };
  const onTableChange = ({
    page,
    sort
  }) => {
    if (page) {
      const {
        index,
        size
      } = page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (sort) {
      const {
        field: fieldSort,
        direction
      } = sort;
      setSortField(fieldSort);
      setSortDirection(direction);
    }
  };
  const getNavUrlParams = (0, _use_get_navigation_url_params.useGetNavigationUrlParams)();
  const getVulnerabilityUrl = (name, queryField) => {
    return getNavUrlParams({
      [queryField]: name
    }, 'vulnerabilities');
  };
  const vulnerabilityStats = (0, _cloudSecurityPosture.getVulnerabilityStats)({
    critical,
    high,
    medium,
    low,
    none
  }, getSeverityStatusColor, setCurrentFilter, currentFilter);
  const renderItem = (0, _react.useCallback)((item, i, field, object) => {
    const references = Array.isArray(object.vulnerability.reference) ? object.vulnerability.reference : [object.vulnerability.reference];
    const url = (0, _cloudSecurityPosture.findReferenceLink)(references, item);
    const actions = [...(field === 'vulnerability.id' && url ? [{
      onClick: () => window.open(url, '_blank'),
      iconType: 'popout',
      ariaLabel: _i18n.i18n.translate('xpack.securitySolution.vulnerabilities.findingsDetailsTable.openUrlInWindow', {
        defaultMessage: 'Open URL in window'
      }),
      title: _i18n.i18n.translate('xpack.securitySolution.vulnerabilities.findingsDetailsTable.openUrlInWindow', {
        defaultMessage: 'Open URL in window'
      })
    }] : [])];
    return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.ActionableBadge, {
      key: `${item}-${i}`,
      item: item,
      index: i,
      actions: actions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 16
      }
    });
  }, []);
  const renderMultiValueCell = (field, finding) => {
    const cellValue = (0, _fp.get)(field, finding);
    if (!Array.isArray(cellValue)) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 16
        }
      }, cellValue || EMPTY_VALUE);
    }
    return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.MultiValueCellPopover, {
      items: cellValue,
      field: field,
      object: finding,
      renderItem: renderItem,
      firstItemRenderer: item => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 40
        }
      }, item),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 9
      }
    });
  };
  const columns = [{
    field: 'vulnerability',
    name: '',
    width: '5%',
    render: (vulnerability, finding) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "expand",
      onClick: () => {
        var _finding$resource, _finding$event;
        const previewPanelProps = {
          id: _constants.VulnerabilityFindingsPreviewPanelKey,
          params: {
            vulnerabilityId: vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id,
            resourceId: finding === null || finding === void 0 ? void 0 : (_finding$resource = finding.resource) === null || _finding$resource === void 0 ? void 0 : _finding$resource.id,
            packageName: finding === null || finding === void 0 ? void 0 : finding[_use_vulnerabilities_findings.VULNERABILITY_FINDING.PACKAGE_NAME],
            packageVersion: finding === null || finding === void 0 ? void 0 : finding[_use_vulnerabilities_findings.VULNERABILITY_FINDING.PACKAGE_VERSION],
            eventId: finding === null || finding === void 0 ? void 0 : (_finding$event = finding.event) === null || _finding$event === void 0 ? void 0 : _finding$event.id,
            scopeId,
            isPreviewMode: true,
            banner: {
              title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.vulnerabilityFinding.PreviewTitle', {
                defaultMessage: 'Preview vulnerability details'
              }),
              backgroundColor: 'warning',
              textColor: 'warning'
            }
          }
        };
        openPreviewPanel(previewPanelProps);
      },
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.vulnerability.table.previewDetailsButtonAriaLabel', {
        defaultMessage: 'Preview vulnerability details'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 11
      }
    })
  }, {
    field: 'score',
    render: score => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CVSScoreBadge, {
      version: score === null || score === void 0 ? void 0 : score.version,
      score: score === null || score === void 0 ? void 0 : score.base,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 13
      }
    })),
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.vulnerability.table.ruleColumnName', {
      defaultMessage: 'CVSS'
    }),
    width: '10%',
    sortable: true
  }, {
    field: _use_vulnerabilities_findings.VULNERABILITY_FINDING.TITLE,
    render: title => {
      if (Array.isArray(title)) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 288,
            columnNumber: 20
          }
        }, title.join(', '));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 291,
          columnNumber: 18
        }
      }, title || EMPTY_VALUE);
    },
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.vulnerability.table.vulnerabilityTitleColumnName', {
      defaultMessage: 'Vulnerability Title'
    }),
    width: '25%',
    sortable: true
  }, {
    field: _use_vulnerabilities_findings.VULNERABILITY_FINDING.ID,
    render: (id, finding) => renderMultiValueCell(_use_vulnerabilities_findings.VULNERABILITY_FINDING.ID, finding),
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.vulnerability.table.vulnerabilityIdColumnName', {
      defaultMessage: 'CVE ID'
    }),
    width: '20%',
    sortable: true
  }, {
    field: _use_vulnerabilities_findings.VULNERABILITY_FINDING.SEVERITY,
    render: severity => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.SeverityStatusBadge, {
      severity: (0, _cloudSecurityPosture.getNormalizedSeverity)(severity),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 15
      }
    }))),
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.vulnerability.table.ruleColumnName', {
      defaultMessage: 'Severity'
    }),
    width: '10%',
    sortable: true
  }, {
    field: _use_vulnerabilities_findings.VULNERABILITY_FINDING.PACKAGE_NAME,
    render: (packageName, finding) => renderMultiValueCell(_use_vulnerabilities_findings.VULNERABILITY_FINDING.PACKAGE_NAME, finding),
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.vulnerability.table.ruleColumnName', {
      defaultMessage: 'Package'
    }),
    width: '30%',
    sortable: true
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    deepLinkId: _deeplinksSecurity.SecurityPageName.cloudSecurityPostureFindings,
    path: `${getVulnerabilityUrl(value, _types.EntityIdentifierFields.hostName)}`,
    target: '_blank',
    external: false,
    onClick: () => {
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.NAV_TO_FINDINGS_BY_HOST_NAME_FROM_ENTITY_FLYOUT);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.vulnerability.tableTitle', {
    defaultMessage: 'Vulnerability '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'popout',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_securitySolutionDistributionBar.DistributionBar, {
    stats: vulnerabilityStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: pageOfItems || [],
    rowHeader: "result",
    columns: columns,
    pagination: pagination,
    onChange: onTableChange,
    "data-test-subj": 'securitySolutionFlyoutVulnerabilitiesFindingsTable',
    sorting: sorting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 11
    }
  })));
});
VulnerabilitiesFindingsDetailsTable.displayName = 'VulnerabilitiesFindingsDetailsTable';