"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseFilterQuery = exports.isEmptyBoolFilterQuery = exports.EMPTY_BOOL_FILTER_QUERY = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_BOOL_FILTER_QUERY = exports.EMPTY_BOOL_FILTER_QUERY = {
  bool: {
    must: [],
    filter: [],
    should: [],
    must_not: []
  }
};
const isEmptyBoolFilterQuery = filterQuery => filterQuery == null || (0, _fp.isEqual)(EMPTY_BOOL_FILTER_QUERY, filterQuery);
exports.isEmptyBoolFilterQuery = isEmptyBoolFilterQuery;
const parseFilterQuery = ({
  filterQuery,
  kqlError
}) => {
  if (kqlError != null || filterQuery == null) {
    return undefined;
  }
  try {
    const parsedQuery = JSON.parse(filterQuery);
    const queryIsValid = (0, _fp.has)('bool', parsedQuery) && !isEmptyBoolFilterQuery(parsedQuery);
    if (queryIsValid) {
      return parsedQuery;
    }
  } catch {
    // ignore
  }
  return undefined;
};
exports.parseFilterQuery = parseFilterQuery;