"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApproximateFutureTime = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApproximateFutureTime = ({
  averageSuccessfulDurationNanoseconds,
  generationStartTime
}) => {
  try {
    if (averageSuccessfulDurationNanoseconds == null) {
      return null;
    }
    const averageSuccessfulDurationSeconds = Math.ceil(averageSuccessfulDurationNanoseconds / 1_000_000_000);
    return (0, _moment.default)(generationStartTime).add(averageSuccessfulDurationSeconds, 'seconds').toDate();
  } catch {
    return null;
  }
};
exports.getApproximateFutureTime = getApproximateFutureTime;