"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addEmptyDataFilterQuery = exports.addEmptyDataFilter = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This function adds an empty filter object to the filters array to remove empty entity.id data
 */
const addEmptyDataFilter = (filters, index) => {
  return [...filters, {
    meta: {
      key: _constants.ASSET_FIELDS.ENTITY_ID,
      index,
      negate: true,
      type: 'phrase',
      params: {
        query: ''
      }
    },
    query: {
      match_phrase: {
        [_constants.ASSET_FIELDS.ENTITY_ID]: ''
      }
    }
  }];
};

/**
 * This function adds an empty filter object to the query bool filter array to remove empty entity.id data
 */
exports.addEmptyDataFilter = addEmptyDataFilter;
const addEmptyDataFilterQuery = queryBoolFilter => {
  const filterQuery = {
    match_phrase: {
      [_constants.ASSET_FIELDS.ENTITY_ID]: ''
    }
  };
  return [...queryBoolFilter, filterQuery];
};
exports.addEmptyDataFilterQuery = addEmptyDataFilterQuery;