"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchGroupedData = exports.getGroupedAssetsQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _rxjs = require("rxjs");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _react = require("react");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../constants");
var _data_view_context = require("../../hooks/data_view_context");
var _add_empty_data_filter = require("../../utils/add_empty_data_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGroupedAssetsQuery = (query, indexPattern) => {
  var _query$query;
  if (!indexPattern) {
    throw new Error('Index pattern is required');
  }
  return {
    ...query,
    query: {
      ...(query === null || query === void 0 ? void 0 : query.query),
      bool: {
        ...(query === null || query === void 0 ? void 0 : (_query$query = query.query) === null || _query$query === void 0 ? void 0 : _query$query.bool),
        must_not: (0, _add_empty_data_filter.addEmptyDataFilterQuery)([])
      }
    },
    index: indexPattern,
    ignore_unavailable: true,
    size: 0
  };
};
exports.getGroupedAssetsQuery = getGroupedAssetsQuery;
const useFetchGroupedData = ({
  query,
  enabled = true
}) => {
  const {
    data,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    dataView
  } = (0, _data_view_context.useDataViewContext)();
  const dataViewIndexPattern = (0, _react.useMemo)(() => {
    return dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern();
  }, [dataView]);
  return (0, _reactQuery.useQuery)([_constants.QUERY_KEY_ASSET_INVENTORY, _constants.QUERY_KEY_GROUPING_DATA, {
    query
  }], async () => {
    const {
      rawResponse: {
        aggregations
      }
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: getGroupedAssetsQuery(query, dataViewIndexPattern)
    }));
    if (!aggregations) throw new Error('Failed to aggregate by, missing resource id');
    return aggregations;
  }, {
    onError: err => (0, _cloudSecurityPosture.showErrorToast)(toasts, err),
    enabled: enabled && !!dataViewIndexPattern,
    keepPreviousData: true
  });
};
exports.useFetchGroupedData = useFetchGroupedData;