"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectTimelineTypeLiteralWithNullRt = exports.SavedObjectTimelineType = exports.SavedObjectTimelineStatus = exports.SavedObjectTimelineRuntimeType = void 0;
var runtimeTypes = _interopRequireWildcard(require("io-ts"));
var _utility_types = require("../../utility_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 *  ColumnHeader Types
 */
const SavedColumnHeaderRuntimeType = runtimeTypes.partial({
  aggregatable: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  category: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  columnHeaderType: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  description: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  example: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  indexes: (0, _utility_types.unionWithNullType)(runtimeTypes.array(runtimeTypes.string)),
  id: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  name: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  placeholder: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  searchable: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  type: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/*
 *  DataProvider Types
 */
const SavedDataProviderQueryMatchBasicRuntimeType = runtimeTypes.partial({
  field: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  displayField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  value: runtimeTypes.union([runtimeTypes.null, runtimeTypes.string, runtimeTypes.array(runtimeTypes.string)]),
  displayValue: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  operator: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedDataProviderQueryMatchRuntimeType = runtimeTypes.partial({
  id: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  name: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  enabled: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  excluded: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  kqlQuery: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  queryMatch: (0, _utility_types.unionWithNullType)(SavedDataProviderQueryMatchBasicRuntimeType)
});
var DataProviderType = /*#__PURE__*/function (DataProviderType) {
  DataProviderType["default"] = "default";
  DataProviderType["template"] = "template";
  return DataProviderType;
}(DataProviderType || {});
const DataProviderTypeLiteralRt = runtimeTypes.union([runtimeTypes.literal(DataProviderType.default), runtimeTypes.literal(DataProviderType.template)]);
const SavedDataProviderRuntimeType = runtimeTypes.partial({
  id: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  name: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  enabled: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  excluded: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  kqlQuery: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  queryMatch: (0, _utility_types.unionWithNullType)(SavedDataProviderQueryMatchBasicRuntimeType),
  and: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedDataProviderQueryMatchRuntimeType)),
  type: (0, _utility_types.unionWithNullType)(DataProviderTypeLiteralRt)
});

/*
 *  Filters Types
 */
const SavedFilterMetaRuntimeType = runtimeTypes.partial({
  alias: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  controlledBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  disabled: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  field: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  formattedValue: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  index: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  key: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  negate: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  params: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  type: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  value: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedFilterRuntimeType = runtimeTypes.partial({
  exists: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  meta: (0, _utility_types.unionWithNullType)(SavedFilterMetaRuntimeType),
  match_all: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  missing: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  query: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  range: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  script: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/*
 *  eqlOptionsQuery -> filterQuery Types
 */
const EqlOptionsRuntimeType = runtimeTypes.partial({
  eventCategoryField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  query: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  tiebreakerField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  timestampField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  size: (0, _utility_types.unionWithNullType)(runtimeTypes.union([runtimeTypes.string, runtimeTypes.number]))
});

/*
 *  kqlQuery -> filterQuery Types
 */
const SavedKueryFilterQueryRuntimeType = runtimeTypes.partial({
  kind: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  expression: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedSerializedFilterQueryQueryRuntimeType = runtimeTypes.partial({
  kuery: (0, _utility_types.unionWithNullType)(SavedKueryFilterQueryRuntimeType),
  serializedQuery: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedFilterQueryQueryRuntimeType = runtimeTypes.partial({
  filterQuery: (0, _utility_types.unionWithNullType)(SavedSerializedFilterQueryQueryRuntimeType)
});

/*
 *  DatePicker Range Types
 */
const SavedDateRangePickerRuntimeType = runtimeTypes.partial({
  /* Before the change of all timestamp to ISO string the values of start and from
   * attributes where a number. Specifically UNIX timestamps.
   * To support old timeline's saved object we need to add the number io-ts type
   */
  start: (0, _utility_types.unionWithNullType)(runtimeTypes.union([runtimeTypes.string, runtimeTypes.number])),
  end: (0, _utility_types.unionWithNullType)(runtimeTypes.union([runtimeTypes.string, runtimeTypes.number]))
});

/*
 *  Favorite Types
 */
const SavedFavoriteRuntimeType = runtimeTypes.partial({
  keySearch: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  favoriteDate: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  fullName: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  userName: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/*
 *  Sort Types
 */

const SavedSortObject = runtimeTypes.partial({
  columnId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  columnType: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  sortDirection: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedSortRuntimeType = runtimeTypes.union([runtimeTypes.array(SavedSortObject), SavedSortObject]);

/*
 *  Timeline Statuses
 */
let SavedObjectTimelineStatus = exports.SavedObjectTimelineStatus = /*#__PURE__*/function (SavedObjectTimelineStatus) {
  SavedObjectTimelineStatus["active"] = "active";
  SavedObjectTimelineStatus["draft"] = "draft";
  SavedObjectTimelineStatus["immutable"] = "immutable";
  return SavedObjectTimelineStatus;
}({});
const TimelineStatusLiteralRt = runtimeTypes.union([runtimeTypes.literal(SavedObjectTimelineStatus.active), runtimeTypes.literal(SavedObjectTimelineStatus.draft), runtimeTypes.literal(SavedObjectTimelineStatus.immutable)]);
var RowRendererId = /*#__PURE__*/function (RowRendererId) {
  RowRendererId["alert"] = "alert";
  RowRendererId["alerts"] = "alerts";
  RowRendererId["auditd"] = "auditd";
  RowRendererId["auditd_file"] = "auditd_file";
  RowRendererId["library"] = "library";
  RowRendererId["netflow"] = "netflow";
  RowRendererId["plain"] = "plain";
  RowRendererId["registry"] = "registry";
  RowRendererId["suricata"] = "suricata";
  RowRendererId["system"] = "system";
  RowRendererId["system_dns"] = "system_dns";
  RowRendererId["system_endgame_process"] = "system_endgame_process";
  RowRendererId["system_file"] = "system_file";
  RowRendererId["system_fim"] = "system_fim";
  RowRendererId["system_security_event"] = "system_security_event";
  RowRendererId["system_socket"] = "system_socket";
  RowRendererId["threat_match"] = "threat_match";
  RowRendererId["zeek"] = "zeek";
  return RowRendererId;
}(RowRendererId || {});
const RowRendererIdRuntimeType = (0, _utility_types.stringEnum)(RowRendererId, 'RowRendererId');

/*
 *  Saved Object Timeline Types
 */
let SavedObjectTimelineType = exports.SavedObjectTimelineType = /*#__PURE__*/function (SavedObjectTimelineType) {
  SavedObjectTimelineType["default"] = "default";
  SavedObjectTimelineType["template"] = "template";
  return SavedObjectTimelineType;
}({});
const SavedObjectTimelineTypeLiteralRt = runtimeTypes.union([runtimeTypes.literal(SavedObjectTimelineType.template), runtimeTypes.literal(SavedObjectTimelineType.default)]);
const SavedObjectTimelineTypeLiteralWithNullRt = exports.SavedObjectTimelineTypeLiteralWithNullRt = (0, _utility_types.unionWithNullType)(SavedObjectTimelineTypeLiteralRt);
const SavedObjectTimelineRuntimeType = exports.SavedObjectTimelineRuntimeType = runtimeTypes.partial({
  columns: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedColumnHeaderRuntimeType)),
  dataProviders: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedDataProviderRuntimeType)),
  dataViewId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  description: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  eqlOptions: (0, _utility_types.unionWithNullType)(EqlOptionsRuntimeType),
  eventType: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  excludedRowRendererIds: (0, _utility_types.unionWithNullType)(runtimeTypes.array(RowRendererIdRuntimeType)),
  favorite: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedFavoriteRuntimeType)),
  filters: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedFilterRuntimeType)),
  indexNames: (0, _utility_types.unionWithNullType)(runtimeTypes.array(runtimeTypes.string)),
  kqlMode: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  kqlQuery: (0, _utility_types.unionWithNullType)(SavedFilterQueryQueryRuntimeType),
  title: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  templateTimelineId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  templateTimelineVersion: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  timelineType: (0, _utility_types.unionWithNullType)(SavedObjectTimelineTypeLiteralRt),
  dateRange: (0, _utility_types.unionWithNullType)(SavedDateRangePickerRuntimeType),
  savedQueryId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  sort: (0, _utility_types.unionWithNullType)(SavedSortRuntimeType),
  status: (0, _utility_types.unionWithNullType)(TimelineStatusLiteralRt),
  created: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  createdBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  updated: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  updatedBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  savedSearchId: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/**
 * This type represents a timeline type stored in a saved object that does not include any fields that reference
 * other saved objects.
 */