"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  AlertClosingReasonValues: true,
  FILTER_OPEN: true,
  FILTER_CLOSED: true,
  FILTER_ACKNOWLEDGED: true
};
exports.FILTER_OPEN = exports.FILTER_CLOSED = exports.FILTER_ACKNOWLEDGED = exports.AlertClosingReasonValues = void 0;
var _zod = require("@kbn/zod");
var _timeline = require("./timeline");
Object.keys(_timeline).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _timeline[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _timeline[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertClosingReasonSchema = _zod.z.enum(['false_positive', 'duplicate', 'true_positive', 'benign_positive', 'automated_closure', 'other']);
const AlertClosingReasonValues = exports.AlertClosingReasonValues = AlertClosingReasonSchema.enum;
const FILTER_OPEN = exports.FILTER_OPEN = 'open';
const FILTER_CLOSED = exports.FILTER_CLOSED = 'closed';
const FILTER_ACKNOWLEDGED = exports.FILTER_ACKNOWLEDGED = 'acknowledged';