"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpsertDashboardMigrationResourcesResponse = exports.UpsertDashboardMigrationResourcesRequestParams = exports.UpsertDashboardMigrationResourcesRequestBody = exports.UpdateDashboardMigrationRequestParams = exports.UpdateDashboardMigrationRequestBody = exports.StopDashboardsMigrationResponse = exports.StopDashboardsMigrationRequestParams = exports.StartDashboardsMigrationResponse = exports.StartDashboardsMigrationRequestParams = exports.StartDashboardsMigrationRequestBody = exports.InstallMigrationDashboardsResponse = exports.InstallMigrationDashboardsRequestParams = exports.InstallMigrationDashboardsRequestBody = exports.GetDashboardMigrationStatsResponse = exports.GetDashboardMigrationStatsRequestParams = exports.GetDashboardMigrationResponse = exports.GetDashboardMigrationResourcesResponse = exports.GetDashboardMigrationResourcesRequestQuery = exports.GetDashboardMigrationResourcesRequestParams = exports.GetDashboardMigrationResourcesMissingResponse = exports.GetDashboardMigrationResourcesMissingRequestParams = exports.GetDashboardMigrationRequestParams = exports.GetDashboardMigrationDashboardsResponse = exports.GetDashboardMigrationDashboardsRequestQuery = exports.GetDashboardMigrationDashboardsRequestParams = exports.GetAllTranslationStatsDashboardMigrationResponse = exports.GetAllTranslationStatsDashboardMigrationRequestParams = exports.GetAllDashboardMigrationsStatsResponse = exports.DeleteDashboardMigrationRequestParams = exports.CreateDashboardMigrationResponse = exports.CreateDashboardMigrationRequestBody = exports.CreateDashboardMigrationDashboardsRequestParams = exports.CreateDashboardMigrationDashboardsRequestBody = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _primitives = require("../../../../api/model/primitives.gen");
var _dashboard_migration = require("../../dashboard_migration.gen");
var _splunk = require("../../vendor/dashboards/splunk.gen");
var _common = require("../../common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: SIEM Dashboard Migration API
 *   version: 1
 */

const CreateDashboardMigrationRequestBody = exports.CreateDashboardMigrationRequestBody = _zod.z.object({
  /**
   * The dashboard migration name
   */
  name: _primitives.NonEmptyString
});
const CreateDashboardMigrationResponse = exports.CreateDashboardMigrationResponse = _zod.z.object({
  /**
   * The migration id created.
   */
  migration_id: _primitives.NonEmptyString
});
const CreateDashboardMigrationDashboardsRequestParams = exports.CreateDashboardMigrationDashboardsRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const CreateDashboardMigrationDashboardsRequestBody = exports.CreateDashboardMigrationDashboardsRequestBody = _zod.z.array(_splunk.SplunkOriginalDashboardExport);
const DeleteDashboardMigrationRequestParams = exports.DeleteDashboardMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetAllDashboardMigrationsStatsResponse = exports.GetAllDashboardMigrationsStatsResponse = _zod.z.array(_dashboard_migration.DashboardMigrationTaskStats);
const GetAllTranslationStatsDashboardMigrationRequestParams = exports.GetAllTranslationStatsDashboardMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetAllTranslationStatsDashboardMigrationResponse = exports.GetAllTranslationStatsDashboardMigrationResponse = _dashboard_migration.DashboardMigrationTranslationStats;
const GetDashboardMigrationRequestParams = exports.GetDashboardMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetDashboardMigrationResponse = exports.GetDashboardMigrationResponse = _dashboard_migration.DashboardMigration;
const GetDashboardMigrationDashboardsRequestQuery = exports.GetDashboardMigrationDashboardsRequestQuery = _zod.z.object({
  page: _zod.z.coerce.number().optional(),
  per_page: _zod.z.coerce.number().optional(),
  sort_field: _primitives.NonEmptyString.optional(),
  sort_direction: _zod.z.enum(['asc', 'desc']).optional(),
  search_term: _zod.z.string().optional(),
  ids: (0, _zodHelpers.ArrayFromString)(_primitives.NonEmptyString).optional(),
  is_installed: _zodHelpers.BooleanFromString.optional(),
  is_fully_translated: _zodHelpers.BooleanFromString.optional(),
  is_partially_translated: _zodHelpers.BooleanFromString.optional(),
  is_untranslatable: _zodHelpers.BooleanFromString.optional(),
  is_failed: _zodHelpers.BooleanFromString.optional()
});
const GetDashboardMigrationDashboardsRequestParams = exports.GetDashboardMigrationDashboardsRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetDashboardMigrationDashboardsResponse = exports.GetDashboardMigrationDashboardsResponse = _zod.z.object({
  /**
   * The total number of rules in migration.
   */
  total: _zod.z.number(),
  data: _zod.z.array(_dashboard_migration.DashboardMigrationDashboard)
});
const GetDashboardMigrationResourcesRequestQuery = exports.GetDashboardMigrationResourcesRequestQuery = _zod.z.object({
  type: _common.SiemMigrationResourceType.optional(),
  names: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  from: _zod.z.coerce.number().optional(),
  size: _zod.z.coerce.number().optional()
});
const GetDashboardMigrationResourcesRequestParams = exports.GetDashboardMigrationResourcesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetDashboardMigrationResourcesResponse = exports.GetDashboardMigrationResourcesResponse = _zod.z.array(_common.SiemMigrationResource);
const GetDashboardMigrationResourcesMissingRequestParams = exports.GetDashboardMigrationResourcesMissingRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});

/**
 * The identified resources missing
 */

const GetDashboardMigrationResourcesMissingResponse = exports.GetDashboardMigrationResourcesMissingResponse = _zod.z.array(_common.SiemMigrationResourceBase);
const GetDashboardMigrationStatsRequestParams = exports.GetDashboardMigrationStatsRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetDashboardMigrationStatsResponse = exports.GetDashboardMigrationStatsResponse = _dashboard_migration.DashboardMigrationTaskStats;
const InstallMigrationDashboardsRequestParams = exports.InstallMigrationDashboardsRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const InstallMigrationDashboardsRequestBody = exports.InstallMigrationDashboardsRequestBody = _zod.z.object({
  /**
   * The list of dashboard migration ids to install
   */
  ids: _zod.z.array(_primitives.NonEmptyString).optional()
});
const InstallMigrationDashboardsResponse = exports.InstallMigrationDashboardsResponse = _zod.z.object({
  /**
   * The number of dashboards that were installed.
   */
  installed: _zod.z.number()
});
const StartDashboardsMigrationRequestParams = exports.StartDashboardsMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const StartDashboardsMigrationRequestBody = exports.StartDashboardsMigrationRequestBody = _zod.z.object({
  /**
   * Settings applicable to current dashboard migration task execution.
   */
  settings: _dashboard_migration.DashboardMigrationTaskExecutionSettings,
  langsmith_options: _common.LangSmithOptions.optional(),
  /**
   * The optional indicator to retry the dashboard translation based on this filter criteria.
   */
  retry: _dashboard_migration.DashboardMigrationRetryFilter.optional()
});
const StartDashboardsMigrationResponse = exports.StartDashboardsMigrationResponse = _zod.z.object({
  /**
   * Indicates the migration has been started. `false` means the migration does not need to be started.
   */
  started: _zod.z.boolean()
});
const StopDashboardsMigrationRequestParams = exports.StopDashboardsMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const StopDashboardsMigrationResponse = exports.StopDashboardsMigrationResponse = _zod.z.object({
  /**
   * Indicates the migration has been stopped.
   */
  stopped: _zod.z.boolean()
});
const UpdateDashboardMigrationRequestParams = exports.UpdateDashboardMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const UpdateDashboardMigrationRequestBody = exports.UpdateDashboardMigrationRequestBody = _zod.z.object({
  /**
   * The dashboard migration name
   */
  name: _primitives.NonEmptyString.optional()
}).strict();
const UpsertDashboardMigrationResourcesRequestParams = exports.UpsertDashboardMigrationResourcesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const UpsertDashboardMigrationResourcesRequestBody = exports.UpsertDashboardMigrationResourcesRequestBody = _zod.z.array(_common.SiemMigrationResourceData);
const UpsertDashboardMigrationResourcesResponse = exports.UpsertDashboardMigrationResourcesResponse = _zod.z.object({
  /**
   * The request has been processed correctly.
   */
  acknowledged: _zod.z.boolean()
});