"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskLevel = exports.RISK_LEVEL_RANGES = void 0;
var _common = require("../../api/entity_analytics/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_LEVEL_RANGES = exports.RISK_LEVEL_RANGES = {
  [_common.EntityRiskLevelsEnum.Unknown]: {
    start: 0,
    stop: 20
  },
  [_common.EntityRiskLevelsEnum.Low]: {
    start: 20,
    stop: 40
  },
  [_common.EntityRiskLevelsEnum.Moderate]: {
    start: 40,
    stop: 70
  },
  [_common.EntityRiskLevelsEnum.High]: {
    start: 70,
    stop: 90
  },
  [_common.EntityRiskLevelsEnum.Critical]: {
    start: 90,
    stop: 100
  }
};
const getRiskLevel = riskScore => {
  if (riskScore >= RISK_LEVEL_RANGES[_common.EntityRiskLevelsEnum.Critical].start) {
    return _common.EntityRiskLevelsEnum.Critical;
  } else if (riskScore >= RISK_LEVEL_RANGES[_common.EntityRiskLevelsEnum.High].start) {
    return _common.EntityRiskLevelsEnum.High;
  } else if (riskScore >= RISK_LEVEL_RANGES[_common.EntityRiskLevelsEnum.Moderate].start) {
    return _common.EntityRiskLevelsEnum.Moderate;
  } else if (riskScore >= RISK_LEVEL_RANGES[_common.EntityRiskLevelsEnum.Low].start) {
    return _common.EntityRiskLevelsEnum.Low;
  } else {
    return _common.EntityRiskLevelsEnum.Unknown;
  }
};
exports.getRiskLevel = getRiskLevel;