"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAntivirusRegistrationEnabled = exports.shouldEnableAntivirusRegistrationForSync = void 0;
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Calculates and updates Antivirus Registration `enabled` state based on the `mode` set by user
 * and by malware protection level in case antivirus registration mode is set to sync with malware.
 *
 * It updates the input parameter in place, i.e. mutates it.
 *
 * @param policy
 */
const updateAntivirusRegistrationEnabled = policy => {
  const modeToEnabled = {
    [_types.AntivirusRegistrationModes.enabled]: true,
    [_types.AntivirusRegistrationModes.disabled]: false,
    [_types.AntivirusRegistrationModes.sync]: shouldEnableAntivirusRegistrationForSync(policy)
  };
  const antivirusRegistrationMode = policy.windows.antivirus_registration.mode;
  if (antivirusRegistrationMode) {
    var _modeToEnabled$antivi;
    // calculate only if `mode` exists
    policy.windows.antivirus_registration.enabled = (_modeToEnabled$antivi = modeToEnabled[antivirusRegistrationMode]) !== null && _modeToEnabled$antivi !== void 0 ? _modeToEnabled$antivi : false;
  }
};
exports.updateAntivirusRegistrationEnabled = updateAntivirusRegistrationEnabled;
const shouldEnableAntivirusRegistrationForSync = policy => policy.windows.malware.mode === _types.ProtectionModes.prevent;
exports.shouldEnableAntivirusRegistrationForSync = shouldEnableAntivirusRegistrationForSync;