"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isServerlessKibanaFlavor = exports.fetchKibanaStatus = void 0;
var _test = require("@kbn/test");
var _format_axios_error = require("../format_axios_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchKibanaStatus = async kbnClient => {
  // We DO NOT use `kbnClient.status.get()` here because the `kbnClient` passed on input could be our enhanced
  // client (created by `x-pack/solutions/security/plugins/security_solution/scripts/endpoint/common/stack_services.ts:267`)
  // which could be using an API key (which the core KbnClient does not support)
  return kbnClient.request({
    method: 'GET',
    path: '/api/status'
  }).then(({
    data
  }) => data).catch(_format_axios_error.catchAxiosErrorFormatAndThrow);
};
/**
 * Checks to see if Kibana/ES is running in serverless mode
 * @param client
 */
exports.fetchKibanaStatus = fetchKibanaStatus;
const isServerlessKibanaFlavor = async client => {
  if (client instanceof _test.KbnClient) {
    var _kbnStatus$status, _kbnStatus$status$plu, _kbnStatus$status$plu2;
    const kbnStatus = await fetchKibanaStatus(client);

    // If we don't have status for plugins, then error
    // the Status API will always return something (its an open API), but if auth was successful,
    // it will also return more data.
    if (!(kbnStatus !== null && kbnStatus !== void 0 && (_kbnStatus$status = kbnStatus.status) !== null && _kbnStatus$status !== void 0 && _kbnStatus$status.plugins)) {
      throw new Error(`Unable to retrieve Kibana plugins status (likely an auth issue with the username being used for kibana)`);
    }
    return ((_kbnStatus$status$plu = kbnStatus.status.plugins) === null || _kbnStatus$status$plu === void 0 ? void 0 : (_kbnStatus$status$plu2 = _kbnStatus$status$plu.serverless) === null || _kbnStatus$status$plu2 === void 0 ? void 0 : _kbnStatus$status$plu2.level) === 'available';
  } else {
    return (await client.info()).version.build_flavor === 'serverless';
  }
};
exports.isServerlessKibanaFlavor = isServerlessKibanaFlavor;