"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractTimelineTemplateReference = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractTimelineTemplateReference = rule => {
  var _rule$timeline_title;
  if (rule.timeline_id == null) {
    return undefined;
  }
  return {
    timeline_id: rule.timeline_id,
    timeline_title: (_rule$timeline_title = rule.timeline_title) !== null && _rule$timeline_title !== void 0 ? _rule$timeline_title : ''
  };
};
exports.extractTimelineTemplateReference = extractTimelineTemplateReference;