"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointActionListRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../endpoint/service/response_actions/constants");
var _constants2 = require("../../../../endpoint/constants");
var _base = require("../common/base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: fix the odd TS error

const commandsSchema = _configSchema.schema.oneOf(
// @ts-expect-error TS2769: No overload matches this call
_constants.RESPONSE_ACTION_API_COMMANDS_NAMES.map(command => _configSchema.schema.literal(command)));
const statusesSchema = {
  // @ts-expect-error TS2769: No overload matches this call
  schema: _configSchema.schema.oneOf(_constants.RESPONSE_ACTION_STATUS.map(status => _configSchema.schema.literal(status))),
  options: {
    minSize: 1,
    maxSize: _constants.RESPONSE_ACTION_STATUS.length
  }
};
const actionTypesSchema = {
  // @ts-expect-error TS2769: No overload matches this call
  schema: _configSchema.schema.oneOf(_constants.RESPONSE_ACTION_TYPE.map(type => _configSchema.schema.literal(type))),
  options: {
    minSize: 1,
    maxSize: _constants.RESPONSE_ACTION_TYPE.length
  }
};
const EndpointActionListRequestSchema = exports.EndpointActionListRequestSchema = {
  query: _configSchema.schema.object({
    agentIds: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1
    }), _configSchema.schema.string({
      minLength: 1
    })])),
    agentTypes: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_base.agentTypesSchema.schema, _base.agentTypesSchema.options), _base.agentTypesSchema.schema])),
    commands: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(commandsSchema, {
      minSize: 1
    }), commandsSchema])),
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 1,
      min: 1
    })),
    pageSize: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: _constants2.ENDPOINT_DEFAULT_PAGE_SIZE,
      min: 1,
      max: 10000
    })),
    startDate: _configSchema.schema.maybe(_configSchema.schema.string()),
    // date ISO strings or moment date
    endDate: _configSchema.schema.maybe(_configSchema.schema.string()),
    // date ISO strings or moment date
    statuses: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(statusesSchema.schema, statusesSchema.options), statusesSchema.schema])),
    userIds: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1
    }), _configSchema.schema.string({
      minLength: 1
    })])),
    withOutputs: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1,
      validate: actionIds => {
        if (actionIds.map(v => v.trim()).some(v => !v.length)) {
          return 'actionIds cannot contain empty strings';
        }
      }
    }), _configSchema.schema.string({
      minLength: 1,
      validate: actionId => {
        if (!actionId.trim().length) {
          return 'actionId cannot be an empty string';
        }
      }
    })])),
    // action types
    types: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(actionTypesSchema.schema, actionTypesSchema.options), actionTypesSchema.schema]))
  })
};