"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleExecutionEventTypeEnum = exports.RuleExecutionEventType = exports.RuleExecutionEvent = exports.LogLevelEnum = exports.LogLevel = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Execution Event Schema
 *   version: not applicable
 */

const LogLevel = exports.LogLevel = _zod.z.enum(['trace', 'debug', 'info', 'warn', 'error']);
const LogLevelEnum = exports.LogLevelEnum = LogLevel.enum;

/**
  * Type of a plain rule execution event:
- message: Simple log message of some log level, such as debug, info or error.
- status-change: We log an event of this type each time a rule changes its status during an execution.
- execution-metrics: We log an event of this type at the end of a rule execution. It contains various execution metrics such as search and indexing durations.
  */

const RuleExecutionEventType = exports.RuleExecutionEventType = _zod.z.enum(['message', 'status-change', 'execution-metrics']);
const RuleExecutionEventTypeEnum = exports.RuleExecutionEventTypeEnum = RuleExecutionEventType.enum;

/**
  * Plain rule execution event. A rule can write many of them during each execution. Events can be of different types and log levels.

NOTE: This is a read model of rule execution events and it is pretty generic. It contains only a subset of their fields: only those fields that are common to all types of execution events.
  */

const RuleExecutionEvent = exports.RuleExecutionEvent = _zod.z.object({
  timestamp: _zod.z.string().datetime(),
  sequence: _zod.z.number().int(),
  level: LogLevel,
  type: RuleExecutionEventType,
  execution_id: _zod.z.string().min(1),
  message: _zod.z.string()
});