"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthIntervalType = exports.HealthIntervalParameters = exports.HealthIntervalGranularity = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Type of the health interval. You can specify:
 * - a relative interval, e.g. "last_hour" = [now-1h; now] where "now" is when health request is made
 * - a custom interval with "from" and "to" timestamps
 */
let HealthIntervalType = exports.HealthIntervalType = /*#__PURE__*/function (HealthIntervalType) {
  HealthIntervalType["last_hour"] = "last_hour";
  HealthIntervalType["last_day"] = "last_day";
  HealthIntervalType["last_week"] = "last_week";
  HealthIntervalType["last_month"] = "last_month";
  HealthIntervalType["last_year"] = "last_year";
  HealthIntervalType["custom_range"] = "custom_range";
  return HealthIntervalType;
}({});
/**
 * Granularity defines how the whole health interval will be split into smaller sub-intervals.
 * Health stats will be calculated for the whole interval + for each sub-interval.
 * Example: if the interval is "last_day" and the granularity is "hour", stats will be calculated:
 * - 1 time for the last 24 hours
 * - 24 times for each hour in that interval
 */
let HealthIntervalGranularity = exports.HealthIntervalGranularity = /*#__PURE__*/function (HealthIntervalGranularity) {
  HealthIntervalGranularity["minute"] = "minute";
  HealthIntervalGranularity["hour"] = "hour";
  HealthIntervalGranularity["day"] = "day";
  HealthIntervalGranularity["week"] = "week";
  HealthIntervalGranularity["month"] = "month";
  return HealthIntervalGranularity;
}({});
/**
 * Time period over which we calculate health stats.
 * This is a "raw" schema for the interval parameters that users can pass to the API.
 */
const HealthIntervalParameters = exports.HealthIntervalParameters = t.union([t.exact(t.type({
  type: t.literal(HealthIntervalType.last_hour),
  granularity: t.literal(HealthIntervalGranularity.minute)
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.last_day),
  granularity: t.union([t.literal(HealthIntervalGranularity.minute), t.literal(HealthIntervalGranularity.hour)])
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.last_week),
  granularity: t.union([t.literal(HealthIntervalGranularity.hour), t.literal(HealthIntervalGranularity.day)])
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.last_month),
  granularity: t.union([t.literal(HealthIntervalGranularity.day), t.literal(HealthIntervalGranularity.week)])
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.last_year),
  granularity: t.union([t.literal(HealthIntervalGranularity.week), t.literal(HealthIntervalGranularity.month)])
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.custom_range),
  granularity: t.union([t.literal(HealthIntervalGranularity.minute), t.literal(HealthIntervalGranularity.hour), t.literal(HealthIntervalGranularity.day), t.literal(HealthIntervalGranularity.week), t.literal(HealthIntervalGranularity.month)]),
  from: _securitysolutionIoTsTypes.IsoDateString,
  to: _securitysolutionIoTsTypes.IsoDateString
}))]);

/**
 * Time period over which we calculate health stats.
 * This interface represents a fully validated and normalized interval object.
 */