"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottleForBulkActionsEnum = exports.ThrottleForBulkActions = exports.RuleDetailsInError = exports.PerformRulesBulkActionResponse = exports.PerformRulesBulkActionRequestQuery = exports.PerformRulesBulkActionRequestBody = exports.NormalizedRuleError = exports.NormalizedRuleAction = exports.BulkManualRuleRun = exports.BulkManualRuleFillGaps = exports.BulkGapsFillingSkipReason = exports.BulkExportRules = exports.BulkExportActionResponse = exports.BulkEnableRules = exports.BulkEditSkipReason = exports.BulkEditRules = exports.BulkEditActionSummary = exports.BulkEditActionResults = exports.BulkEditActionResponse = exports.BulkDuplicateRules = exports.BulkDisableRules = exports.BulkDeleteRules = exports.BulkActionsDryRunErrCodeEnum = exports.BulkActionsDryRunErrCode = exports.BulkActionTypeEnum = exports.BulkActionType = exports.BulkActionSkipResult = exports.BulkActionEditTypeEnum = exports.BulkActionEditType = exports.BulkActionEditPayloadTimeline = exports.BulkActionEditPayloadTags = exports.BulkActionEditPayloadSetAlertSuppressionForThreshold = exports.BulkActionEditPayloadSetAlertSuppression = exports.BulkActionEditPayloadSchedule = exports.BulkActionEditPayloadRuleActions = exports.BulkActionEditPayloadInvestigationFields = exports.BulkActionEditPayloadInternal = exports.BulkActionEditPayloadIndexPatterns = exports.BulkActionEditPayloadDeleteAlertSuppression = exports.BulkActionEditPayloadAlertSuppressionInternal = exports.BulkActionEditPayloadAlertSuppression = exports.BulkActionEditPayload = exports.BulkActionBase = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_schemas = require("../../model/rule_schema/rule_schemas.gen");
var _common_attributes = require("../../model/rule_schema/common_attributes.gen");
var _threshold_attributes = require("../../model/rule_schema/specific_attributes/threshold_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Actions API endpoint
 *   version: 2023-10-31
 */

const BulkEditSkipReason = exports.BulkEditSkipReason = _zod.z.literal('RULE_NOT_MODIFIED');
const BulkGapsFillingSkipReason = exports.BulkGapsFillingSkipReason = _zod.z.literal('NO_GAPS_TO_FILL');
const BulkActionSkipResult = exports.BulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  skip_reason: _zod.z.union([BulkEditSkipReason, BulkGapsFillingSkipReason])
});
const RuleDetailsInError = exports.RuleDetailsInError = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional()
});
const BulkActionsDryRunErrCode = exports.BulkActionsDryRunErrCode = _zod.z.enum(['IMMUTABLE', 'PREBUILT_CUSTOMIZATION_LICENSE', 'MACHINE_LEARNING_AUTH', 'MACHINE_LEARNING_INDEX_PATTERN', 'ESQL_INDEX_PATTERN', 'MANUAL_RULE_RUN_FEATURE', 'MANUAL_RULE_RUN_DISABLED_RULE', 'THRESHOLD_RULE_TYPE_IN_SUPPRESSION', 'UNSUPPORTED_RULE_IN_SUPPRESSION_FOR_THRESHOLD', 'RULE_FILL_GAPS_DISABLED_RULE']);
const BulkActionsDryRunErrCodeEnum = exports.BulkActionsDryRunErrCodeEnum = BulkActionsDryRunErrCode.enum;
const NormalizedRuleError = exports.NormalizedRuleError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().int(),
  err_code: BulkActionsDryRunErrCode.optional(),
  rules: _zod.z.array(RuleDetailsInError)
});
const BulkEditActionResults = exports.BulkEditActionResults = _zod.z.object({
  updated: _zod.z.array(_rule_schemas.RuleResponse),
  created: _zod.z.array(_rule_schemas.RuleResponse),
  deleted: _zod.z.array(_rule_schemas.RuleResponse),
  skipped: _zod.z.array(BulkActionSkipResult)
});

/**
 * A rule can only be skipped when the bulk action to be performed on it results in nothing being done. For example, if the `edit` action is used to add a tag to a rule that already has that tag, or to delete an index pattern that is not specified in a rule. Objects returned in `attributes.results.skipped` will only include rules' `id`, `name`, and `skip_reason`.
 */

const BulkEditActionSummary = exports.BulkEditActionSummary = _zod.z.object({
  failed: _zod.z.number().int(),
  skipped: _zod.z.number().int(),
  succeeded: _zod.z.number().int(),
  total: _zod.z.number().int()
});
const BulkEditActionResponse = exports.BulkEditActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  rules_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: BulkEditActionResults,
    summary: BulkEditActionSummary,
    errors: _zod.z.array(NormalizedRuleError).optional()
  })
});
const BulkExportActionResponse = exports.BulkExportActionResponse = _zod.z.string();
const BulkActionBase = exports.BulkActionBase = _zod.z.object({
  /**
   * Query to filter rules.
   */
  query: _zod.z.string().optional(),
  /** 
      * Array of rule `id`s to which a bulk action will be applied. Do not use rule's `rule_id` here.
  Only valid when query property is undefined.
        */
  ids: _zod.z.array(_zod.z.string()).min(1).optional(),
  /**
   * Gaps range start, valid only when query is provided
   */
  gaps_range_start: _zod.z.string().optional(),
  /**
   * Gaps range end, valid only when query is provided
   */
  gaps_range_end: _zod.z.string().optional()
});
const BulkDeleteRules = exports.BulkDeleteRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('delete')
}));
const BulkDisableRules = exports.BulkDisableRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('disable')
}));
const BulkEnableRules = exports.BulkEnableRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('enable')
}));
const BulkExportRules = exports.BulkExportRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('export')
}));
const BulkDuplicateRules = exports.BulkDuplicateRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('duplicate'),
  /**
   * Duplicate object that describes applying an update action.
   */
  duplicate: _zod.z.object({
    /**
     * Whether to copy exceptions from the original rule
     */
    include_exceptions: _zod.z.boolean(),
    /**
     * Whether to copy expired exceptions from the original rule
     */
    include_expired_exceptions: _zod.z.boolean()
  }).optional()
}));
const BulkManualRuleRun = exports.BulkManualRuleRun = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('run'),
  /**
   * Object that describes applying a manual rule run action.
   */
  run: _zod.z.object({
    /**
     * Start date of the manual rule run
     */
    start_date: _zod.z.string(),
    /**
     * End date of the manual rule run
     */
    end_date: _zod.z.string()
  })
}));
const BulkManualRuleFillGaps = exports.BulkManualRuleFillGaps = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('fill_gaps'),
  /**
   * Object that describes applying a manual gap fill action for the specified time range.
   */
  fill_gaps: _zod.z.object({
    /**
     * Start date of the manual gap fill
     */
    start_date: _zod.z.string(),
    /**
     * End date of the manual gap fill
     */
    end_date: _zod.z.string()
  })
}));

/**
  * Defines the maximum interval in which a rule’s actions are executed.
> info
> The rule level `throttle` field is deprecated in Elastic Security 8.8 and will remain active for at least the next 12 months.
> In Elastic Security 8.8 and later, you can use the `frequency` field to define frequencies for individual actions. Actions without frequencies will acquire a converted version of the rule’s `throttle` field. In the response, the converted `throttle` setting appears in the individual actions' `frequency` field.

  */

const ThrottleForBulkActions = exports.ThrottleForBulkActions = _zod.z.enum(['rule', '1h', '1d', '7d']);
const ThrottleForBulkActionsEnum = exports.ThrottleForBulkActionsEnum = ThrottleForBulkActions.enum;
const BulkActionType = exports.BulkActionType = _zod.z.enum(['enable', 'disable', 'export', 'delete', 'duplicate', 'edit', 'run', 'fill_gaps']);
const BulkActionTypeEnum = exports.BulkActionTypeEnum = BulkActionType.enum;
const BulkActionEditType = exports.BulkActionEditType = _zod.z.enum(['add_tags', 'delete_tags', 'set_tags', 'add_index_patterns', 'delete_index_patterns', 'set_index_patterns', 'set_timeline', 'add_rule_actions', 'set_rule_actions', 'set_schedule', 'add_investigation_fields', 'delete_investigation_fields', 'set_investigation_fields', 'delete_alert_suppression', 'set_alert_suppression', 'set_alert_suppression_for_threshold']);
const BulkActionEditTypeEnum = exports.BulkActionEditTypeEnum = BulkActionEditType.enum;
const NormalizedRuleAction = exports.NormalizedRuleAction = _zod.z.object({
  group: _common_attributes.RuleActionGroup.optional(),
  id: _common_attributes.RuleActionId,
  params: _common_attributes.RuleActionParams,
  frequency: _common_attributes.RuleActionFrequency.optional(),
  alerts_filter: _common_attributes.RuleActionAlertsFilter.optional()
}).strict();

/**
  * Edits rule actions of rules.

- `add_rule_actions` adds rule actions to rules. This action is non-idempotent, meaning that even if the same rule action already exists for a rule, it will be added again with a new unique ID.
- `set_rule_actions` sets rule actions for rules. This action is non-idempotent, meaning that even if the same set of rule actions already exists for a rule, it will be set again and the actions will receive new unique IDs.

  */

const BulkActionEditPayloadRuleActions = exports.BulkActionEditPayloadRuleActions = _zod.z.object({
  type: _zod.z.enum(['add_rule_actions', 'set_rule_actions']),
  value: _zod.z.object({
    throttle: ThrottleForBulkActions.optional(),
    actions: _zod.z.array(NormalizedRuleAction)
  })
});

/**
  * Overwrites schedule of rules. 

- `set_schedule` sets a schedule for rules. If the same schedule already exists for a rule, no changes are made.

Both `interval` and `lookback` have a format of "{integer}{time_unit}", where accepted time units are `s` for seconds, `m` for minutes, and `h` for hours. The integer must be positive and larger than 0. Examples: "45s", "30m", "6h"

  */

const BulkActionEditPayloadSchedule = exports.BulkActionEditPayloadSchedule = _zod.z.object({
  type: _zod.z.literal('set_schedule'),
  value: _zod.z.object({
    /**
     * Interval in which the rule runs. For example, `"1h"` means the rule runs every hour.
     */
    interval: _zod.z.string().regex(/^[1-9]\d*[smh]$/),
    /** 
      * Lookback time for the rules.
    Additional look-back time that the rule analyzes. For example, "10m" means the rule analyzes the last 10 minutes of data in addition to the frequency interval.
        */
    lookback: _zod.z.string().regex(/^[1-9]\d*[smh]$/)
  })
});

/**
  * Edits index patterns of rulesClient.

- `add_index_patterns` adds index patterns to rules. If an index pattern already exists for a rule, no changes are made.
- `delete_index_patterns` removes index patterns from rules. If an index pattern does not exist for a rule, no changes are made.
- `set_index_patterns` sets index patterns for rules, overwriting any existing index patterns. If the set of index patterns is the same as the existing index patterns, no changes are made.

  */

const BulkActionEditPayloadIndexPatterns = exports.BulkActionEditPayloadIndexPatterns = _zod.z.object({
  type: _zod.z.enum(['add_index_patterns', 'delete_index_patterns', 'set_index_patterns']),
  value: _common_attributes.IndexPatternArray,
  /**
   * Resets the data view for the rule.
   */
  overwrite_data_views: _zod.z.boolean().optional()
});

/**
  * Edits tags of rules.

- `add_tags` adds tags to rules. If a tag already exists for a rule, no changes are made.
- `delete_tags` removes tags from rules. If a tag does not exist for a rule, no changes are made.
- `set_tags` sets tags for rules, overwriting any existing tags. If the set of tags is the same as the existing tags, no changes are made.

  */

const BulkActionEditPayloadTags = exports.BulkActionEditPayloadTags = _zod.z.object({
  type: _zod.z.enum(['add_tags', 'delete_tags', 'set_tags']),
  value: _common_attributes.RuleTagArray
});

/**
  * Edits investigation fields of rules.

- `add_investigation_fields` adds investigation fields to rules. If an investigation field already exists for a rule, no changes are made.
- `delete_investigation_fields` removes investigation fields from rules. If an investigation field does not exist for a rule, no changes are made.
- `set_investigation_fields` sets investigation fields for rules. If the set of investigation fields is the same as the existing investigation fields, no changes are made.

  */

const BulkActionEditPayloadInvestigationFields = exports.BulkActionEditPayloadInvestigationFields = _zod.z.object({
  type: _zod.z.enum(['add_investigation_fields', 'delete_investigation_fields', 'set_investigation_fields']),
  value: _common_attributes.InvestigationFields
});

/**
  * Edits timeline of rules.

- `set_timeline` sets a timeline for rules. If the same timeline already exists for a rule, no changes are made.

  */

const BulkActionEditPayloadTimeline = exports.BulkActionEditPayloadTimeline = _zod.z.object({
  type: _zod.z.literal('set_timeline'),
  value: _zod.z.object({
    timeline_id: _common_attributes.TimelineTemplateId,
    timeline_title: _common_attributes.TimelineTemplateTitle
  })
});
const BulkActionEditPayloadSetAlertSuppression = exports.BulkActionEditPayloadSetAlertSuppression = _zod.z.object({
  type: _zod.z.literal('set_alert_suppression'),
  value: _common_attributes.AlertSuppression
});
const BulkActionEditPayloadSetAlertSuppressionForThreshold = exports.BulkActionEditPayloadSetAlertSuppressionForThreshold = _zod.z.object({
  type: _zod.z.literal('set_alert_suppression_for_threshold'),
  value: _threshold_attributes.ThresholdAlertSuppression
});
const BulkActionEditPayloadDeleteAlertSuppression = exports.BulkActionEditPayloadDeleteAlertSuppression = _zod.z.object({
  type: _zod.z.literal('delete_alert_suppression')
});
const BulkActionEditPayloadAlertSuppressionInternal = exports.BulkActionEditPayloadAlertSuppressionInternal = _zod.z.union([BulkActionEditPayloadSetAlertSuppression, BulkActionEditPayloadSetAlertSuppressionForThreshold, BulkActionEditPayloadDeleteAlertSuppression]);
const BulkActionEditPayloadAlertSuppression = exports.BulkActionEditPayloadAlertSuppression = BulkActionEditPayloadAlertSuppressionInternal;
const BulkActionEditPayloadInternal = exports.BulkActionEditPayloadInternal = _zod.z.union([BulkActionEditPayloadTags, BulkActionEditPayloadIndexPatterns, BulkActionEditPayloadInvestigationFields, BulkActionEditPayloadTimeline, BulkActionEditPayloadRuleActions, BulkActionEditPayloadSchedule, BulkActionEditPayloadAlertSuppression]);
const BulkActionEditPayload = exports.BulkActionEditPayload = BulkActionEditPayloadInternal;
const BulkEditRules = exports.BulkEditRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('edit'),
  /**
   * Array of objects containing the edit operations
   */
  edit: _zod.z.array(BulkActionEditPayload).min(1)
}));
const PerformRulesBulkActionRequestQuery = exports.PerformRulesBulkActionRequestQuery = _zod.z.object({
  /** 
      * Enables dry run mode for the request call.
  Enable dry run mode to verify that bulk actions can be applied to specified rules. Certain rules, such as prebuilt Elastic rules on a Basic subscription, can’t be edited and will return errors in the request response. Error details will contain an explanation, the rule name and/or ID, and additional troubleshooting information.
  To enable dry run mode on a request, add the query parameter `dry_run=true` to the end of the request URL. Rules specified in the request will be temporarily updated. These updates won’t be written to Elasticsearch.
  > info
  > Dry run mode is not supported for the `export` bulk action. A 400 error will be returned in the request response.
        */
  dry_run: _zodHelpers.BooleanFromString.optional()
});
const PerformRulesBulkActionRequestBody = exports.PerformRulesBulkActionRequestBody = _zod.z.union([BulkDeleteRules, BulkDisableRules, BulkEnableRules, BulkExportRules, BulkDuplicateRules, BulkManualRuleRun, BulkManualRuleFillGaps, BulkEditRules]);
const PerformRulesBulkActionResponse = exports.PerformRulesBulkActionResponse = _zod.z.union([BulkEditActionResponse, BulkExportActionResponse]);