"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createV2NavigationTree = void 0;
var _react = require("react");
var _navigation_tree = require("../../navigation_tree");
var _ = require("../..");
var _links = require("../../links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyIconWorkflow = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./v2_icons/workflow'))).then(({
  iconWorkflow
}) => ({
  default: iconWorkflow
})));

// TODO delete when the `bullseye` EUI icon has been updated
const LazyIconFindings = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./v2_icons/findings'))).then(({
  iconFindings
}) => ({
  default: iconFindings
})));

// TODO delete when the EUI icon has been updated
const LazyIconIntelligence = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./v2_icons/intelligence'))).then(({
  iconIntelligence
}) => ({
  default: iconIntelligence
})));
const createV2NavigationTree = core => [{
  link: 'discover',
  iconV2: 'discoverApp',
  sideNavVersion: 'v2'
}, _navigation_tree.defaultNavigationTree.dashboards({
  sideNavVersion: 'v2'
}), _navigation_tree.defaultNavigationTree.rules({
  sideNavVersion: 'v2'
}), {
  id: _.SecurityPageName.alerts,
  iconV2: 'warning',
  link: (0, _links.securityLink)(_.SecurityPageName.alerts),
  sideNavVersion: 'v2'
}, {
  // TODO: update icon from EUI
  iconV2: LazyIconWorkflow,
  link: 'workflows',
  withBadge: true,
  badgeTypeV2: 'techPreview',
  badgeOptions: {
    icon: 'beaker',
    tooltip: _links.i18nStrings.workflows.badgeTooltip
  },
  sideNavVersion: 'v2'
}, {
  id: _.SecurityPageName.attackDiscovery,
  iconV2: 'bolt',
  link: (0, _links.securityLink)(_.SecurityPageName.attackDiscovery),
  sideNavVersion: 'v2'
}, {
  id: _.SecurityPageName.cloudSecurityPostureFindings,
  // TODO change this to the `bullseye` EUI icon when available
  iconV2: LazyIconFindings,
  link: (0, _links.securityLink)(_.SecurityPageName.cloudSecurityPostureFindings),
  sideNavVersion: 'v2'
}, _navigation_tree.defaultNavigationTree.cases({
  sideNavVersion: 'v2'
}), _navigation_tree.defaultNavigationTree.entityAnalytics({
  sideNavVersion: 'v2'
}), _navigation_tree.defaultNavigationTree.explore({
  sideNavVersion: 'v2'
}), _navigation_tree.defaultNavigationTree.investigations({
  sideNavVersion: 'v2'
}), {
  id: _.SecurityPageName.threatIntelligence,
  // TODO change this to the `compute` EUI icon when available
  iconV2: LazyIconIntelligence,
  link: (0, _links.securityLink)(_.SecurityPageName.threatIntelligence),
  sideNavVersion: 'v2'
}, {
  id: _.SecurityPageName.assetInventory,
  iconV2: 'editorChecklist',
  link: (0, _links.securityLink)(_.SecurityPageName.assetInventory),
  sideNavVersion: 'v2'
}, _navigation_tree.defaultNavigationTree.assets(core, {
  sideNavVersion: 'v2'
}), _navigation_tree.defaultNavigationTree.ml({
  sideNavVersion: 'v2'
})];
exports.createV2NavigationTree = createV2NavigationTree;