"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nStrings = exports.i18nStrings = {
  rules: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.rules', {
      defaultMessage: 'Rules'
    }),
    management: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.rules.management', {
        defaultMessage: 'Management'
      }),
      discover: _i18n.i18n.translate('securitySolutionPackages.navLinks.rules.discover', {
        defaultMessage: 'Discover'
      })
    }
  },
  investigations: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.investigations', {
      defaultMessage: 'Investigations'
    })
  },
  explore: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.explore', {
      defaultMessage: 'Explore'
    })
  },
  workflows: {
    badgeTooltip: _i18n.i18n.translate('securitySolutionPackages.navLinks.workflows.badgeTooltip', {
      defaultMessage: 'This functionality is experimental and not supported. It may change or be removed at any time.'
    })
  },
  launchpad: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.launchpad', {
      defaultMessage: 'Security launchpad'
    })
  },
  assets: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.assets', {
      defaultMessage: 'Assets'
    }),
    fleet: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.assets.fleet', {
        defaultMessage: 'Fleet'
      }),
      policies: _i18n.i18n.translate('securitySolutionPackages.navLinks.assets.fleetPolicies', {
        defaultMessage: 'Policies'
      })
    },
    endpoints: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.assets.endpoints', {
        defaultMessage: 'Endpoints'
      })
    },
    integrationsCallout: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.assets.integrationsCallout.title', {
        defaultMessage: 'Integrations'
      }),
      body: _i18n.i18n.translate('securitySolutionPackages.navLinks.assets.integrationsCallout.body', {
        defaultMessage: 'Choose an integration to start collecting and analyzing your data.'
      }),
      button: _i18n.i18n.translate('securitySolutionPackages.navLinks.assets.integrationsCallout.button', {
        defaultMessage: 'Browse integrations'
      })
    }
  },
  ml: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml', {
      defaultMessage: 'Machine Learning'
    }),
    overview: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.overview', {
      defaultMessage: 'Overview'
    }),
    dataVisualizer: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.dataVisualizer', {
      defaultMessage: 'Data visualizer'
    }),
    notifications: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.notifications', {
      defaultMessage: 'Notifications'
    }),
    memoryUsage: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.memoryUsage', {
      defaultMessage: 'Memory usage'
    }),
    anomalyDetection: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.anomalyDetection', {
        defaultMessage: 'Anomaly detection'
      }),
      jobs: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.anomalyDetection.jobs', {
        defaultMessage: 'Jobs'
      }),
      anomalyExplorer: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.anomalyDetection.anomalyExplorer', {
        defaultMessage: 'Anomaly explorer'
      }),
      singleMetricViewer: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.anomalyDetection.singleMetricViewer', {
        defaultMessage: 'Single metric viewer'
      }),
      suppliedConfigurations: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.anomalyDetection.suppliedConfigurations', {
        defaultMessage: 'Supplied configurations'
      }),
      settings: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.anomalyDetection.settings', {
        defaultMessage: 'Settings'
      })
    },
    dataFrameAnalytics: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.dataFrameAnalytics', {
        defaultMessage: 'Data frame analytics'
      }),
      jobs: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.dataFrameAnalytics.jobs', {
        defaultMessage: 'Jobs'
      }),
      resultExplorer: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.dataFrameAnalytics.resultExplorer', {
        defaultMessage: 'Result explorer'
      }),
      analyticsMap: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.dataFrameAnalytics.analyticsMap', {
        defaultMessage: 'Analytics map'
      })
    },
    modelManagement: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.modelManagement', {
        defaultMessage: 'Model management'
      }),
      trainedModels: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.modelManagement.trainedModels', {
        defaultMessage: 'Trained models'
      })
    },
    aiopsLabs: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.aiopsLabs', {
        defaultMessage: 'AIOps labs'
      }),
      logRateAnalysis: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.aiopsLabs.logRateAnalysis', {
        defaultMessage: 'Log rate analysis'
      }),
      logPatternAnalysis: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.aiopsLabs.logPatternAnalysis', {
        defaultMessage: 'Log pattern analysis'
      }),
      changePointDetection: _i18n.i18n.translate('securitySolutionPackages.navLinks.ml.aiopsLabs.changePointDetection', {
        defaultMessage: 'Change point detection'
      })
    }
  },
  entityRiskScore: _i18n.i18n.translate('securitySolutionPackages.navLinks.entityRiskScore', {
    defaultMessage: 'Entity risk score'
  }),
  entityStore: _i18n.i18n.translate('securitySolutionPackages.navLinks.entityStore', {
    defaultMessage: 'Entity store'
  }),
  entityAnalytics: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.entityAnalytics', {
      defaultMessage: 'Entity analytics'
    })
  },
  devTools: _i18n.i18n.translate('securitySolutionPackages.navLinks.devTools', {
    defaultMessage: 'Developer tools'
  }),
  management: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.management.title', {
      defaultMessage: 'Management'
    })
  },
  projectSettings: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.projectSettings.title', {
      defaultMessage: 'Project Settings'
    })
  },
  stackManagement: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.title', {
      defaultMessage: 'Stack Management'
    }),
    ingest: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.ingest', {
        defaultMessage: 'Ingest'
      })
    },
    data: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.data', {
        defaultMessage: 'Data'
      })
    },
    access: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.access', {
        defaultMessage: 'Access'
      }),
      usersAndRoles: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.usersAndRoles', {
        defaultMessage: 'Manage organization members'
      })
    },
    alertsAndInsights: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.alertsAndInsights', {
        defaultMessage: 'Alerts and Insights'
      })
    },
    security: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.security', {
        defaultMessage: 'Security'
      })
    },
    kibana: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.kibana', {
        defaultMessage: 'Kibana'
      })
    },
    content: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.content', {
        defaultMessage: 'Content'
      })
    },
    stack: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.stack', {
        defaultMessage: 'Stack'
      })
    },
    ai: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.ai', {
        defaultMessage: 'AI'
      })
    },
    other: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.mngt.other', {
        defaultMessage: 'Other'
      })
    }
  },
  launchPad: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.launchPad', {
      defaultMessage: 'Launchpad'
    }),
    migrations: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.launchPad.migrations', {
        defaultMessage: 'Migrations'
      })
    }
  },
  // also used in sidenav v2
  // for serverless tiers (EASE (search_ai_lake|ai_soc_engine) | essential | complete)
  ingestAndManageData: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.dataManagement', {
      defaultMessage: 'Data management'
    }),
    ingestAndIntegrations: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.ingestAndManageData.ingestAndIntegrations', {
        defaultMessage: 'Ingest and Integrations'
      })
    },
    indicesAndDataStreams: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.ingestAndManageData.indicesAndDataStreams', {
        defaultMessage: 'Indices and data streams'
      })
    }
  },
  // rename this key to stackManagement once we switch to v2 completely
  // also used in sidenav v2 for
  // serverless tiers (EASE (search_ai_lake|ai_soc_engine) | essential | complete)
  stackManagementV2: {
    title: _i18n.i18n.translate('securitySolutionPackages.navLinks.stackManagement_v2.title', {
      defaultMessage: 'Stack Management'
    }),
    home: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.stackManagement_v2.home', {
        defaultMessage: 'Home'
      })
    },
    serverlessTitle: _i18n.i18n.translate('securitySolutionPackages.navLinks.stackManagement_v2.serverlessTitle', {
      defaultMessage: 'Admin and Settings'
    }),
    organization: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.stackManagement_v2.organization', {
        defaultMessage: 'Organization'
      })
    },
    alertsAndInsights: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.stackManagement_v2.alertsInsights', {
        defaultMessage: 'Alerts and Insights'
      })
    },
    security: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.stackManagement_v2.security', {
        defaultMessage: 'Security'
      })
    },
    data: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.stackManagement_v2.data', {
        defaultMessage: 'Data'
      })
    },
    kibana: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.stackManagement_v2.kibana', {
        defaultMessage: 'Kibana'
      })
    },
    // serverless only
    access: {
      title: _i18n.i18n.translate('securitySolutionPackages.navLinks.stackManagement_v2.access', {
        defaultMessage: 'Access'
      })
    }
  }
};