"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelineBaseKibanaFeature = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineBaseKibanaFeature = params => ({
  id: _constants.TIMELINE_FEATURE_ID,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionTimelineTitle', {
    defaultMessage: 'Timeline'
  }),
  order: 1100,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.TIMELINE_FEATURE_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  privileges: {
    all: {
      app: [_constants.TIMELINE_FEATURE_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      savedObject: {
        all: params.savedObjects,
        read: params.savedObjects
      },
      ui: [],
      api: []
    },
    read: {
      app: [_constants.TIMELINE_FEATURE_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      savedObject: {
        all: [],
        read: params.savedObjects
      },
      ui: [],
      api: []
    }
  }
});
exports.getTimelineBaseKibanaFeature = getTimelineBaseKibanaFeature;