"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_LICENSE_MESSAGE = exports.SIEM_MIGRATION_UPSELLING_TITLE = exports.SIEM_MIGRATION_UPGRADE_LICENSE_MESSAGE = exports.SIEM_MIGRATION_RULES_PAGE_UPGRADE_LICENSE_MESSAGE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPGRADE_LICENSE_MESSAGE = requiredLicense => _i18n.i18n.translate('xpack.securitySolutionEss.upselling.upgradeLicenseMessage', {
  defaultMessage: 'This feature is available with {requiredLicense} or higher subscription',
  values: {
    requiredLicense
  }
});
exports.UPGRADE_LICENSE_MESSAGE = UPGRADE_LICENSE_MESSAGE;
const SIEM_MIGRATION_UPSELLING_TITLE = requiredLicense => _i18n.i18n.translate('xpack.securitySolutionEss.upselling.siemMigrations.title', {
  defaultMessage: '{requiredLicense} license required',
  values: {
    requiredLicense
  }
});
exports.SIEM_MIGRATION_UPSELLING_TITLE = SIEM_MIGRATION_UPSELLING_TITLE;
const SIEM_MIGRATION_UPGRADE_LICENSE_MESSAGE = exports.SIEM_MIGRATION_UPGRADE_LICENSE_MESSAGE = _i18n.i18n.translate('xpack.securitySolutionEss.upselling.siemMigrations.upgradeLicenseMessage', {
  defaultMessage: 'To use this feature, upgrade your Elastic subscription level.'
});
const SIEM_MIGRATION_RULES_PAGE_UPGRADE_LICENSE_MESSAGE = exports.SIEM_MIGRATION_RULES_PAGE_UPGRADE_LICENSE_MESSAGE = _i18n.i18n.translate('xpack.securitySolutionEss.upselling.siemMigrations.rulesPageUpgradeLicenseMessage', {
  defaultMessage: 'To use this feature, upgrade your Elastic subscription level. If you have created a migration previously, you will be able to access it after upgrade.'
});