"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setOnboardingSettings = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setOnboardingSettings = services => {
  const {
    securitySolution,
    application,
    cloud
  } = services;
  securitySolution.setOnboardingSettings({
    userUrl: application.getUrlForApp('management', {
      path: 'security/users/create'
    }),
    isAgentlessAvailable: false,
    deploymentUrl: cloud.deploymentUrl
  });
};
exports.setOnboardingSettings = setOnboardingSettings;