"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePasswordForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/users/components/change_password_form/change_password_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getInitialState() {
  return {
    shouldValidate: false,
    currentPassword: '',
    newPassword: '',
    confirmPassword: '',
    currentPasswordError: false,
    changeInProgress: false
  };
}
class ChangePasswordForm extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getForm", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 7
        }
      }, this.props.isUserChangingOwnPassword && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, this.validateCurrentPassword(), {
        fullWidth: true,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.account.changePasswordForm.currentPasswordLabel",
          defaultMessage: "Current password",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 75,
            columnNumber: 15
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
        autoComplete: "off",
        "data-test-subj": "currentPassword",
        type: "dual",
        value: this.state.currentPassword,
        onChange: this.onCurrentPasswordChange,
        disabled: this.state.changeInProgress,
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.account.changePasswordForm.passwordRequirements",
          defaultMessage: "Use at least 6 characters.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 13
          }
        })
      }, this.validateNewPassword(), {
        fullWidth: true,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.account.changePasswordForm.newPasswordLabel",
          defaultMessage: "New password",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 103,
            columnNumber: 13
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
        autoComplete: "new-password",
        "data-test-subj": "newPassword",
        type: "dual",
        value: this.state.newPassword,
        onChange: this.onNewPasswordChange,
        disabled: this.state.changeInProgress,
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 11
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, this.validateConfirmPassword(), {
        fullWidth: true,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.account.changePasswordForm.confirmPasswordLabel",
          defaultMessage: "Confirm new password",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 123,
            columnNumber: 13
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
        autoComplete: "new-password",
        "data-test-subj": "confirmNewPassword",
        type: "dual",
        value: this.state.confirmPassword,
        onChange: this.onConfirmPasswordChange,
        disabled: this.state.changeInProgress,
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 11
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        responsive: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.onChangePasswordClick,
        fill: true,
        isLoading: this.state.changeInProgress,
        "data-test-subj": "changePasswordButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.account.changePasswordForm.saveChangesButtonLabel",
        defaultMessage: "Change password",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: this.onCancelClick,
        isDisabled: this.state.changeInProgress,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.account.changePasswordForm.cancelButtonLabel",
        defaultMessage: "Reset",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 17
        }
      }))))));
    });
    (0, _defineProperty2.default)(this, "onCurrentPasswordChange", e => {
      this.setState({
        currentPassword: e.target.value,
        currentPasswordError: false
      });
    });
    (0, _defineProperty2.default)(this, "onNewPasswordChange", e => {
      this.setState({
        newPassword: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onConfirmPasswordChange", e => {
      this.setState({
        confirmPassword: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onCancelClick", () => {
      this.setState(getInitialState());
    });
    (0, _defineProperty2.default)(this, "onChangePasswordClick", async () => {
      this.setState({
        shouldValidate: true,
        currentPasswordError: false
      }, () => {
        const {
          isInvalid
        } = this.validateForm();
        if (isInvalid) {
          return;
        }
        this.setState({
          changeInProgress: true
        }, () => this.performPasswordChange());
      });
    });
    (0, _defineProperty2.default)(this, "validateCurrentPassword", (shouldValidate = this.state.shouldValidate) => {
      if (!shouldValidate || !this.props.isUserChangingOwnPassword) {
        return {
          isInvalid: false
        };
      }
      if (this.state.currentPasswordError) {
        return {
          isInvalid: true,
          error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.account.changePasswordForm.invalidPassword",
            defaultMessage: "Current password is incorrect.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 206,
              columnNumber: 11
            }
          })
        };
      }
      if (!this.state.currentPassword) {
        return {
          isInvalid: true,
          error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.account.currentPasswordRequired",
            defaultMessage: "Current password is required.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 218,
              columnNumber: 11
            }
          })
        };
      }
      return {
        isInvalid: false
      };
    });
    (0, _defineProperty2.default)(this, "validateNewPassword", (shouldValidate = this.state.shouldValidate) => {
      const {
        newPassword
      } = this.state;
      const minPasswordLength = 6;
      if (shouldValidate && newPassword.length < minPasswordLength) {
        return {
          isInvalid: true,
          error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.account.passwordLengthDescription",
            defaultMessage: "Password is too short.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 238,
              columnNumber: 11
            }
          })
        };
      }
      return {
        isInvalid: false
      };
    });
    (0, _defineProperty2.default)(this, "validateConfirmPassword", (shouldValidate = this.state.shouldValidate) => {
      const {
        newPassword,
        confirmPassword
      } = this.state;
      if (shouldValidate && newPassword !== confirmPassword) {
        return {
          isInvalid: true,
          error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.account.passwordsDoNotMatch",
            defaultMessage: "Passwords do not match.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 257,
              columnNumber: 11
            }
          })
        };
      }
      return {
        isInvalid: false
      };
    });
    (0, _defineProperty2.default)(this, "validateForm", () => {
      const validation = [this.validateCurrentPassword(true), this.validateNewPassword(true), this.validateConfirmPassword(true)];
      const firstFailure = validation.find(result => result.isInvalid);
      if (firstFailure) {
        return firstFailure;
      }
      return {
        isInvalid: false
      };
    });
    (0, _defineProperty2.default)(this, "performPasswordChange", async () => {
      try {
        await this.props.userAPIClient.changePassword(this.props.user.username, this.state.newPassword, this.state.currentPassword);
        this.handleChangePasswordSuccess();
      } catch (e) {
        this.handleChangePasswordFailure(e);
      } finally {
        this.setState({
          changeInProgress: false
        });
      }
    });
    (0, _defineProperty2.default)(this, "handleChangePasswordSuccess", () => {
      this.props.notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.security.account.changePasswordSuccess', {
          defaultMessage: 'Your password has been changed.'
        }),
        'data-test-subj': 'passwordUpdateSuccess'
      });
      this.setState({
        currentPasswordError: false,
        shouldValidate: false,
        newPassword: '',
        currentPassword: '',
        confirmPassword: ''
      });
      if (this.props.onChangePassword) {
        this.props.onChangePassword();
      }
    });
    (0, _defineProperty2.default)(this, "handleChangePasswordFailure", error => {
      if (error.body && error.body.statusCode === 403) {
        this.setState({
          currentPasswordError: true
        });
      } else {
        this.props.notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.users.editUser.settingPasswordErrorMessage', {
          defaultMessage: 'Error setting password: {message}',
          values: {
            message: _lodash.default.get(error, 'body.message')
          }
        }));
      }
    });
    this.state = getInitialState();
  }
  render() {
    return this.getForm();
  }
}
exports.ChangePasswordForm = ChangePasswordForm;