"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.categorizeAggregations = exports.UsersFilterButton = exports.UsernameWithIcon = exports.TypesFilterButton = exports.MAX_PAGINATED_ITEMS = exports.ExpiredFilterButton = exports.ApiKeysTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _securityApiKeyManagement = require("@kbn/security-api-key-management");
var _userProfileComponents = require("@kbn/user-profile-components");
var _api_keys_empty_prompt = require("./api_keys_empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/api_keys/api_keys_grid/api_keys_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_PAGINATED_ITEMS = exports.MAX_PAGINATED_ITEMS = 10000;
const FiltersContext = /*#__PURE__*/(0, _react.createContext)({
  types: [],
  usernames: [],
  filters: {},
  onFilterChange: () => {}
});
const ApiKeysTable = ({
  apiKeys,
  createdApiKey,
  currentUser,
  onClick,
  onDelete,
  canManageApiKeys = false,
  canManageOwnApiKeys = false,
  readOnly = false,
  loading = false,
  totalItemCount = 0,
  onTableChange,
  pagination,
  onSearchChange,
  aggregations,
  sortingOptions,
  queryErrors,
  resetQuery,
  query,
  queryFilters,
  onFilterChange
}) => {
  const columns = [];
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const {
    typeFilters,
    usernameFilters,
    expired
  } = categorizeAggregations(aggregations);
  const deletable = item => canManageApiKeys || canManageOwnApiKeys && item.username === currentUser.username;
  const isBadRequest = queryErrors && (0, _api_keys_empty_prompt.doesErrorIndicateBadQuery)(queryErrors);
  const itemsToDisplay = isBadRequest ? [] : apiKeys;
  columns.push({
    field: 'name',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.nameColumnName",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }),
    sortable: true,
    render: (name, item) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => onClick(item),
        "data-test-subj": `apiKeyRowName-${item.name}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 11
        }
      }, name);
    }
  }, {
    field: 'type',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.typeColumnName",
      defaultMessage: "Type",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }),
    sortable: true,
    render: (type, apiKeyRecord) => {
      var _apiKeyRecord$metadat;
      let keyType = type;
      if (apiKeyRecord.name.indexOf('Alerting: ') === 0 || ((_apiKeyRecord$metadat = apiKeyRecord.metadata) === null || _apiKeyRecord$metadat === void 0 ? void 0 : _apiKeyRecord$metadat.managed) === true) {
        keyType = 'managed';
      }
      return /*#__PURE__*/_react.default.createElement(_securityApiKeyManagement.ApiKeyBadge, {
        type: keyType,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 16
        }
      });
    }
  });
  if (canManageApiKeys || usernameFilters.length > 1) {
    columns.push({
      field: 'username',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.ownerColumnName",
        defaultMessage: "Owner",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 9
        }
      }),
      sortable: true,
      render: username => /*#__PURE__*/_react.default.createElement(UsernameWithIcon, {
        username: username,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 60
        }
      })
    });
  }
  columns.push({
    field: 'creation',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.createdColumnName",
      defaultMessage: "Created",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 9
      }
    }),
    sortable: true,
    mobileOptions: {
      show: false
    },
    render: (creation, item) => /*#__PURE__*/_react.default.createElement(_securityApiKeyManagement.TimeToolTip, {
      timestamp: creation,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 9
      }
    }, item.id === (createdApiKey === null || createdApiKey === void 0 ? void 0 : createdApiKey.id) ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.createdBadge",
      defaultMessage: "Just now",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 15
      }
    })) : null)
  }, {
    field: 'expiration',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.statusColumnName",
      defaultMessage: "Status",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 9
      }
    }),
    sortable: true,
    render: expiration => /*#__PURE__*/_react.default.createElement(_securityApiKeyManagement.ApiKeyStatus, {
      expiration: expiration,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 39
      }
    })
  });
  if (!readOnly) {
    columns.push({
      width: `${24 + 2 * 8}px`,
      actions: [{
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeys.table.deleteAction",
          defaultMessage: "Delete",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 220,
            columnNumber: 13
          }
        }),
        description: _i18n.i18n.translate('xpack.security.management.apiKeys.table.deleteDescription', {
          defaultMessage: 'Delete this API key'
        }),
        icon: 'trash',
        type: 'icon',
        color: 'danger',
        onClick: item => onDelete([item]),
        available: deletable,
        'data-test-subj': item => `apiKeysTableDeleteAction-${item.name}`
      }]
    });
  }
  const filters = [];
  if (typeFilters.length > 1) {
    filters.push({
      type: 'custom_component',
      component: TypesFilterButton
    });
  }
  if (expired > 0) {
    filters.push({
      type: 'custom_component',
      component: ExpiredFilterButton
    });
  }
  if (usernameFilters.length > 1) {
    filters.push({
      type: 'custom_component',
      component: UsersFilterButton
    });
  }
  const exceededResultCount = totalItemCount > MAX_PAGINATED_ITEMS;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FiltersContext.Provider, {
    value: {
      types: [...typeFilters],
      usernames: [...usernameFilters],
      filters: queryFilters,
      onFilterChange
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: query,
    box: {
      'data-test-subj': 'apiKeysSearchBar',
      incremental: true,
      schema: {
        strict: true,
        fields: {
          name: {
            type: 'string'
          },
          type: {
            type: 'string'
          },
          username: {
            type: 'string'
          },
          owner: {
            type: 'string'
          },
          expired: {
            type: 'boolean'
          }
        }
      }
    },
    filters: filters,
    onChange: onSearchChange,
    toolsLeft: selectedItems.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => onDelete(selectedItems),
      color: "danger",
      iconType: "trash",
      "data-test-subj": "bulkInvalidateActionButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.invalidateApiKeyButton",
      defaultMessage: "Delete {count, plural, one {API key} other {# API keys}}",
      values: {
        count: selectedItems.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 17
      }
    })) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 7
    }
  }), isBadRequest ? /*#__PURE__*/_react.default.createElement(_api_keys_empty_prompt.ApiKeysEmptyPrompt, {
    error: queryErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    onClick: () => {
      resetQuery();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeys.resetQueryButton",
    defaultMessage: "Reset query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, exceededResultCount && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "apiKeysTableTooManyResultsLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.apiKeys.table.tooManyResultsLabel",
    defaultMessage: "Showing {limit} of {totalItemCount, plural, one {# api key} other {# api keys}}",
    values: {
      totalItemCount,
      limit: MAX_PAGINATED_ITEMS
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: itemsToDisplay,
    itemId: "id",
    columns: columns,
    loading: loading,
    pagination: pagination,
    onChange: onTableChange,
    selection: readOnly ? undefined : {
      selectable: deletable,
      onSelectionChange: setSelectedItems
    },
    sorting: {
      sort: {
        field: sortingOptions.field,
        direction: sortingOptions.direction
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 11
    }
  })));
};
exports.ApiKeysTable = ApiKeysTable;
const TypesFilterButton = ({
  query,
  onChange
}) => {
  const {
    types,
    filters,
    onFilterChange
  } = (0, _react.useContext)(FiltersContext);
  if (!onChange) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, types.includes('rest') ? /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "user",
    iconSide: "left",
    isToggle: true,
    isSelected: filters.type === 'rest',
    hasActiveFilters: filters.type === 'rest',
    onClick: () => {
      onFilterChange({
        ...filters,
        type: filters.type === 'rest' ? undefined : 'rest'
      });
    },
    withNext: types.includes('cross_cluster') || types.includes('managed'),
    "data-test-subj": "personalFilterButton",
    "aria-label": _i18n.i18n.translate('xpack.security.accountManagement.apiKeyBadge.personalAriaLabel', {
      defaultMessage: 'Filter personal API keys'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyBadge.restTitle",
    defaultMessage: "Personal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 11
    }
  })) : null, types.includes('cross_cluster') ? /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "cluster",
    iconSide: "left",
    isToggle: true,
    isSelected: filters.type === 'cross_cluster',
    hasActiveFilters: filters.type === 'cross_cluster',
    onClick: () => {
      onFilterChange({
        ...filters,
        type: filters.type === 'cross_cluster' ? undefined : 'cross_cluster'
      });
    },
    withNext: types.includes('managed'),
    "data-test-subj": "crossClusterFilterButton",
    "aria-label": _i18n.i18n.translate('xpack.security.accountManagement.apiKeyBadge.crossClusterAriaLabel', {
      defaultMessage: 'Filter cross-cluster API keys'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyBadge.crossClusterLabel",
    defaultMessage: "Cross-Cluster",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 11
    }
  })) : null, types.includes('managed') ? /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "gear",
    iconSide: "left",
    isToggle: true,
    isSelected: filters.type === 'managed',
    hasActiveFilters: filters.type === 'managed',
    onClick: () => {
      onFilterChange({
        ...filters,
        type: filters.type === 'managed' ? undefined : 'managed'
      });
    },
    "data-test-subj": "managedFilterButton",
    "aria-label": _i18n.i18n.translate('xpack.security.accountManagement.apiKeyBadge.managedAriaLabel', {
      defaultMessage: 'Filter managed API keys'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyBadge.managedTitle",
    defaultMessage: "Managed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 11
    }
  })) : null);
};
exports.TypesFilterButton = TypesFilterButton;
const ExpiredFilterButton = ({
  query,
  onChange
}) => {
  const {
    filters,
    onFilterChange
  } = (0, _react.useContext)(FiltersContext);
  if (!onChange) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: filters.expired === false,
    hasActiveFilters: filters.expired === false,
    onClick: () => {
      if (filters.expired === false) {
        onFilterChange({
          ...filters,
          expired: undefined
        });
      } else {
        onFilterChange({
          ...filters,
          expired: false
        });
      }
    },
    withNext: true,
    "data-test-subj": "activeFilterButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 484,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.apiKeys.table.activeFilter",
    defaultMessage: "Active",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 498,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: filters.expired === true,
    hasActiveFilters: filters.expired === true,
    onClick: () => {
      if (filters.expired === true) {
        onFilterChange({
          ...filters,
          expired: undefined
        });
      } else {
        onFilterChange({
          ...filters,
          expired: true
        });
      }
    },
    "data-test-subj": "expiredFilterButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 503,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.apiKeys.table.expiredFilter",
    defaultMessage: "Expired",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 9
    }
  })));
};
exports.ExpiredFilterButton = ExpiredFilterButton;
const UsersFilterButton = ({
  query,
  onChange
}) => {
  const {
    usernames,
    filters,
    onFilterChange
  } = (0, _react.useContext)(FiltersContext);
  const filteredUsernames = filters.usernames || [];
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  if (!onChange) {
    return null;
  }
  let numActiveFilters = 0;
  const clause = filters.usernames || [];
  if (clause.length) {
    numActiveFilters = clause.length;
  }
  const usernamesMatchingSearchTerm = searchTerm ? usernames.filter(username => username.includes(searchTerm)) : usernames;
  return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: () => setIsOpen(toggle => !toggle),
      isSelected: isOpen,
      numFilters: usernames.length,
      hasActiveFilters: numActiveFilters ? true : false,
      numActiveFilters: numActiveFilters,
      "data-test-subj": "ownerFilterButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 550,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.ownerFilter",
      defaultMessage: "Owner",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 559,
        columnNumber: 11
      }
    })),
    isOpen: isOpen,
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    panelClassName: "euiFilterGroup__popoverPanel",
    closePopover: () => setIsOpen(false),
    selectableProps: {
      options: usernamesMatchingSearchTerm.map(username => ({
        uid: username,
        user: {
          username
        },
        enabled: false,
        data: {}
      })),
      onSearchChange: setSearchTerm,
      selectedOptions: usernames.filter(username => filteredUsernames.includes(username)).map(username => ({
        uid: username,
        user: {
          username
        },
        enabled: false,
        data: {}
      })),
      onChange: nextSelectedOptions => {
        const nextFilters = nextSelectedOptions.map(option => option.user.username);
        onFilterChange({
          ...filters,
          usernames: nextFilters
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 5
    }
  });
};
exports.UsersFilterButton = UsersFilterButton;
const UsernameWithIcon = ({
  username
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s",
  responsive: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 598,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 599,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
  user: {
    username
  },
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 600,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 602,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "apiKeyUsername",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 603,
    columnNumber: 7
  }
}, username)));
exports.UsernameWithIcon = UsernameWithIcon;
const categorizeAggregations = aggregationResponse => {
  const typeFilters = [];
  const usernameFilters = [];
  let expiredCount = 0;
  if (aggregationResponse && Object.keys(aggregationResponse).length > 0) {
    var _expired$doc_count;
    const {
      usernames,
      types,
      expired,
      managed
    } = aggregationResponse;
    const typeBuckets = types !== null && types !== void 0 && types.buckets.length ? types.buckets : [];
    const usernameBuckets = usernames !== null && usernames !== void 0 && usernames.buckets.length ? usernames.buckets : [];
    typeBuckets.forEach(type => {
      typeFilters.push(type.key);
    });
    usernameBuckets.forEach(username => {
      usernameFilters.push(`${username.key}`);
    });
    const {
      namePrefixBased,
      metadataBased
    } = (managed === null || managed === void 0 ? void 0 : managed.buckets) || {};
    if (namePrefixBased !== null && namePrefixBased !== void 0 && namePrefixBased.doc_count && namePrefixBased.doc_count > 0 || metadataBased !== null && metadataBased !== void 0 && metadataBased.doc_count && metadataBased.doc_count > 0) {
      typeFilters.push('managed');
    }
    expiredCount = (_expired$doc_count = expired === null || expired === void 0 ? void 0 : expired.doc_count) !== null && _expired$doc_count !== void 0 ? _expired$doc_count : 0;
  }
  return {
    typeFilters,
    usernameFilters,
    expired: expiredCount
  };
};
exports.categorizeAggregations = categorizeAggregations;