"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCapabilities = useCapabilities;
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns capabilities for a specific feature, or alternatively the entire capabilities object.
 * @param featureId ID of feature
 */

function useCapabilities(featureId) {
  const {
    services
  } = (0, _public.useKibana)();
  if (featureId) {
    return services.application.capabilities[featureId];
  }
  return services.application.capabilities;
}