"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationService = void 0;
var _access_agreement = require("./access_agreement");
var _capture_url = require("./capture_url");
var _logged_out = require("./logged_out");
var _login = require("./login");
var _logout = require("./logout");
var _overwritten_session = require("./overwritten_session");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AuthenticationService {
  setup({
    application,
    fatalErrors,
    config,
    getStartServices,
    http
  }) {
    const getCurrentUser = async () => await http.get('/internal/security/me', {
      asSystemRequest: true
    });
    const areAPIKeysEnabled = async () => (await http.get('/internal/security/api_key/_enabled')).apiKeysEnabled;
    _access_agreement.accessAgreementApp.create({
      application,
      getStartServices
    });
    _capture_url.captureURLApp.create({
      application,
      fatalErrors,
      http
    });
    _login.loginApp.create({
      application,
      config,
      getStartServices,
      http
    });
    _logout.logoutApp.create({
      application,
      http
    });
    _logged_out.loggedOutApp.create({
      application,
      getStartServices,
      http
    });
    _overwritten_session.overwrittenSessionApp.create({
      application,
      authc: {
        getCurrentUser
      },
      getStartServices
    });
    return {
      getCurrentUser,
      areAPIKeysEnabled
    };
  }
}
exports.AuthenticationService = AuthenticationService;