"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchProfilerLocatorDefinition = exports.SEARCH_PROFILER_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_PROFILER_LOCATOR_ID = exports.SEARCH_PROFILER_LOCATOR_ID = 'SEARCH_PROFILER_LOCATOR';
class SearchProfilerLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", SEARCH_PROFILER_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      loadFrom,
      index
    }) => {
      const indexQueryParam = index ? `?index=${index}` : '';
      const loadFromQueryParam = index && loadFrom ? `&load_from=${loadFrom}` : '';
      return {
        app: 'dev_tools',
        path: `#/searchprofiler${indexQueryParam}${loadFromQueryParam}`,
        state: {
          loadFrom,
          index
        }
      };
    });
  }
}
exports.SearchProfilerLocatorDefinition = SearchProfilerLocatorDefinition;