"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasIndices = void 0;
var _public = require("@kbn/es-ui-shared-plugin/public");
var _constants = require("../../../common/constants");
var _app_context = require("../contexts/app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHasIndices = () => {
  const {
    http
  } = (0, _app_context.useAppContext)();
  return (0, _public.useRequest)(http, {
    path: `${_constants.API_BASE_PATH}/has_indices`,
    method: 'get'
  });
};
exports.useHasIndices = useHasIndices;