"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _styles = require("./styles");
var _styles2 = require("../styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const sharedStyles = (0, _styles.useStyles)();
  return {
    // Import shared styles
    ...sharedStyles,
    // Component-specific styles only used in this component
    // Highlighting style for tree row (from prfDevTool__tvRow--last)
    tvRowLast: (0, _react.css)`
      cursor: pointer;
    `,
    // Tree row table layout (from prfDevTool__profileTree__tvRow)
    tvRow: (0, _react.css)`
      display: table;
      width: 100%;
      table-layout: fixed;
    `,
    // Shard details link styling (from prfDevTool__profileTree__shardDetails)
    shardDetails: (0, _styles2.useSharedDetailsStyles)().shardDetails,
    // Badge styling (from prfDevTool__profileTree__badge)
    badge: (0, _react.css)`
      border: none;
      display: block;
    `,
    // Detail styling (from prfDevTool__detail - standalone class)
    detail: (0, _react.css)`
      font-size: ${(0, _eui.useEuiFontSize)('s').fontSize};
      padding-left: calc(${euiTheme.size.l} - 3px); // Alignment is weird (original comment)
      margin-bottom: ${euiTheme.size.s};
      display: flex;
      justify-content: space-between;

      .euiLink {
        flex-shrink: 0;
      }
    `
  };
};
exports.useStyles = useStyles;