"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSynonymRule = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../common/constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchSynonymRule = (synonymsSetId, ruleId) => {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useQuery)({
    queryKey: [_constants.SYNONYMS_RULE_FETCH_QUERY_KEY, synonymsSetId, ruleId],
    queryFn: async () => {
      return await http.get(`/internal/search_synonyms/synonyms/${synonymsSetId}/${ruleId}`);
    },
    enabled: !!synonymsSetId && !!ruleId
  });
};
exports.useFetchSynonymRule = useFetchSynonymRule;