"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndices = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isHidden(index) {
  var _index$settings, _index$settings$index, _index$settings2, _index$settings2$inde;
  return ((_index$settings = index.settings) === null || _index$settings === void 0 ? void 0 : (_index$settings$index = _index$settings.index) === null || _index$settings$index === void 0 ? void 0 : _index$settings$index.hidden) === true || ((_index$settings2 = index.settings) === null || _index$settings2 === void 0 ? void 0 : (_index$settings2$inde = _index$settings2.index) === null || _index$settings2$inde === void 0 ? void 0 : _index$settings2$inde.hidden) === 'true';
}
function isClosed(index) {
  var _index$settings3, _index$settings3$inde, _index$settings4, _index$settings4$inde;
  return ((_index$settings3 = index.settings) === null || _index$settings3 === void 0 ? void 0 : (_index$settings3$inde = _index$settings3.index) === null || _index$settings3$inde === void 0 ? void 0 : _index$settings3$inde.verified_before_close) === true || ((_index$settings4 = index.settings) === null || _index$settings4 === void 0 ? void 0 : (_index$settings4$inde = _index$settings4.index) === null || _index$settings4$inde === void 0 ? void 0 : _index$settings4$inde.verified_before_close) === 'true';
}
const fetchIndices = async (client, searchQuery, {
  exact
} = {
  exact: false
}) => {
  const indexPattern = exact && searchQuery ? searchQuery : searchQuery ? `*${searchQuery}*` : '*';
  const allIndexMatches = await client.indices.get({
    expand_wildcards: ['open'],
    // for better performance only compute aliases and settings of indices but not mappings
    features: ['aliases', 'settings'],
    // only get specified index properties from ES to keep the response under 536MB
    // node.js string length limit: https://github.com/nodejs/node/issues/33960
    filter_path: ['*.aliases', '*.settings.index.hidden', '*.settings.index.verified_before_close'],
    index: indexPattern
  });
  const allIndexNames = Object.keys(allIndexMatches).filter(indexName => allIndexMatches[indexName] && !isHidden(allIndexMatches[indexName]) && !isClosed(allIndexMatches[indexName]));
  const allAliases = allIndexNames.reduce((acc, indexName) => {
    const aliases = allIndexMatches[indexName].aliases;
    if (aliases) {
      Object.keys(aliases).forEach(alias => {
        if (!acc.includes(alias)) {
          acc.push(alias);
        }
      });
    }
    return acc;
  }, []);
  const allOptions = [...allIndexNames, ...allAliases];
  const indexNames = searchQuery ? allOptions.filter(indexName => indexName.includes(searchQuery.toLowerCase())) : allOptions;
  return {
    indexNames
  };
};
exports.fetchIndices = fetchIndices;