"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesetDetailEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../../common");
var _queryRulesContextAlt = _interopRequireDefault(require("../../assets/query-rules-context-alt.svg"));
var _queryRulesContextAltDark = _interopRequireDefault(require("../../assets/query-rules-context-alt-dark.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/empty_prompt/ruleset_detail_empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RulesetDetailEmptyPrompt = ({
  isFilter = false
}) => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const positionRelative = (0, _react2.css)({
    position: 'relative'
  });
  const imgProps = (0, _react2.css)({
    width: '100%',
    height: '100%',
    objectFit: 'cover'
  });
  const gradientOverlay = (0, _react2.css)({
    background: `linear-gradient(180deg, ${(0, _eui.transparentize)(euiTheme.colors.backgroundBasePlain, 0)}, ${(0, _eui.transparentize)(euiTheme.colors.backgroundBasePlain, 1)} 100%)`,
    position: 'absolute',
    bottom: 0,
    height: '30px',
    width: '100%'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, isFilter ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchQueryRules.rulesetDetailEmptyPrompt.filterTitle",
    defaultMessage: "No rules match your search",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchQueryRules.rulesetDetailEmptyPrompt.title",
    defaultMessage: "Add your first rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 15
    }
  }))), isFilter && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: positionRelative,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: colorMode === 'DARK' ? _queryRulesContextAltDark.default : _queryRulesContextAlt.default,
    alt: _common.PLUGIN_TITLE,
    css: imgProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: gradientOverlay,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, "\xA0"))));
};
exports.RulesetDetailEmptyPrompt = RulesetDetailEmptyPrompt;