"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChat = void 0;
var _use_ai_assist_chat = require("./use_ai_assist_chat");
var _use_kibana = require("./use_kibana");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useChat = () => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const chatHelpers = (0, _use_ai_assist_chat.useAIAssistChat)({
    api: async request => {
      const response = await services.http.post(_types.APIRoutes.POST_CHAT_MESSAGE, {
        ...request,
        rawResponse: true,
        asResponse: true
      });
      return response.response;
    }
  });
  return chatHelpers;
};
exports.useChat = useChat;