"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryViewTitlePanel = exports.QueryViewSidebarContainer = exports.QueryViewContainer = exports.PanelFillContainer = exports.FullHeight = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FullHeight = exports.FullHeight = (0, _react.css)({
  height: '100%'
});
const PanelFillContainer = exports.PanelFillContainer = (0, _react.css)({
  // This is needed to maintain the resizable container height when rendering output editor with larger content
  height: '90%'
});
const QueryViewContainer = euiTheme => (0, _react.css)({
  padding: euiTheme.size.l,
  paddingRight: 0
});
exports.QueryViewContainer = QueryViewContainer;
const QueryViewSidebarContainer = euiTheme => (0, _react.css)({
  padding: euiTheme.size.l,
  paddingLeft: 0
});
exports.QueryViewSidebarContainer = QueryViewSidebarContainer;
const QueryViewTitlePanel = euiTheme => (0, _react.css)({
  borderBottom: euiTheme.border.thin,
  padding: `${euiTheme.size.s} ${euiTheme.size.base}`
});
exports.QueryViewTitlePanel = QueryViewTitlePanel;