"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAllInferenceEndpointsState = useAllInferenceEndpointsState;
var _react = require("react");
var _constants = require("../components/all_inference_endpoints/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAllInferenceEndpointsState() {
  const [tableState, setTableState] = (0, _react.useState)(_constants.DEFAULT_INFERENCE_ENDPOINTS_TABLE_STATE);
  const setState = (0, _react.useCallback)(state => {
    setTableState(state);
  }, []);
  return {
    queryParams: {
      ..._constants.DEFAULT_INFERENCE_ENDPOINTS_TABLE_STATE.queryParams,
      ...tableState.queryParams
    },
    setQueryParams: newQueryParams => {
      setState({
        filterOptions: tableState.filterOptions,
        queryParams: {
          ...tableState.queryParams,
          ...newQueryParams
        }
      });
    },
    filterOptions: {
      ..._constants.DEFAULT_INFERENCE_ENDPOINTS_TABLE_STATE.filterOptions,
      ...tableState.filterOptions
    },
    setFilterOptions: newFilterOptions => {
      setState({
        filterOptions: {
          ...tableState.filterOptions,
          ...newFilterOptions
        },
        queryParams: tableState.queryParams
      });
    }
  };
}