"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  DELETE_TITLE: true,
  CONFIRM_DELETE_WARNING: true,
  DELETE_ACTION_LABEL: true,
  SCANNING_USAGE_LABEL: true,
  NO_USAGE_FOUND_LABEL: true,
  POTENTIAL_FAILURE_LABEL: true,
  IGNORE_POTENTIAL_ERRORS_LABEL: true,
  COUNT_USAGE_LABEL: true,
  SEARCH_LABEL: true,
  SEARCH_ARIA_LABEL: true,
  OPEN_INDEX_MANAGEMENT: true
};
exports.SEARCH_LABEL = exports.SEARCH_ARIA_LABEL = exports.SCANNING_USAGE_LABEL = exports.POTENTIAL_FAILURE_LABEL = exports.OPEN_INDEX_MANAGEMENT = exports.NO_USAGE_FOUND_LABEL = exports.IGNORE_POTENTIAL_ERRORS_LABEL = exports.DELETE_TITLE = exports.DELETE_ACTION_LABEL = exports.COUNT_USAGE_LABEL = exports.CONFIRM_DELETE_WARNING = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../../../../../../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_TITLE = exports.DELETE_TITLE = _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.title', {
  defaultMessage: 'Delete inference endpoint'
});
const CONFIRM_DELETE_WARNING = exports.CONFIRM_DELETE_WARNING = _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.confirmQuestion', {
  defaultMessage: 'Deleting an inference endpoint currently in use will cause failures in ingest and query attempts.'
});
const DELETE_ACTION_LABEL = exports.DELETE_ACTION_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.actions.deleteSingleEndpoint', {
  defaultMessage: 'Delete endpoint'
});
const SCANNING_USAGE_LABEL = exports.SCANNING_USAGE_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.scanningMessage', {
  defaultMessage: 'Scanning for usage'
});
const NO_USAGE_FOUND_LABEL = exports.NO_USAGE_FOUND_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.noUsageFound', {
  defaultMessage: 'No Usage Found'
});
const POTENTIAL_FAILURE_LABEL = exports.POTENTIAL_FAILURE_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.potentialFailure', {
  defaultMessage: 'Potential Failures'
});
const IGNORE_POTENTIAL_ERRORS_LABEL = exports.IGNORE_POTENTIAL_ERRORS_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.ignoreErrors', {
  defaultMessage: 'Ignore errors and force deletion'
});
const COUNT_USAGE_LABEL = count => _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.countUsage', {
  defaultMessage: 'Found {count} {count, plural, =1 {usage} other {usages}}',
  values: {
    count
  }
});
exports.COUNT_USAGE_LABEL = COUNT_USAGE_LABEL;
const SEARCH_LABEL = exports.SEARCH_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.searchLabel', {
  defaultMessage: 'Search'
});
const SEARCH_ARIA_LABEL = exports.SEARCH_ARIA_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.searchARIALabel', {
  defaultMessage: 'Search indices and pipelines'
});
const OPEN_INDEX_MANAGEMENT = exports.OPEN_INDEX_MANAGEMENT = _i18n.i18n.translate('xpack.searchInferenceEndpoints.confirmDeleteEndpoint.openIndexManagement', {
  defaultMessage: 'Open Index Management'
});