"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initQueryClient = initQueryClient;
var _reactQuery = require("@kbn/react-query");
var _errors = require("../utils/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initQueryClient(toasts) {
  return new _reactQuery.QueryClient({
    mutationCache: new _reactQuery.MutationCache({
      onError: (e, _vars, _ctx, _mutation) => {
        // TODO: can we verify this instead of a blind cast?
        const error = e;
        toasts.addError(error, {
          title: error.name,
          toastMessage: (0, _errors.getErrorMessage)(error),
          toastLifeTimeMs: 1000
        });
      }
    }),
    queryCache: new _reactQuery.QueryCache({
      onError: error => {
        // 404s are often functionally okay and shouldn't show toasts by default
        if ((0, _errors.getErrorCode)(error) === 404) {
          return;
        }
        if ((0, _errors.isKibanaServerError)(error) && !error.skipToast) {
          toasts.addError(error, {
            title: error.name,
            toastMessage: (0, _errors.getErrorMessage)(error),
            toastLifeTimeMs: 1000
          });
        }
      }
    })
  });
}