"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteIndex = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../constants");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeleteIndex = indexName => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const indices = [indexName];
  const body = JSON.stringify({
    indices
  });
  const queryClient = (0, _reactQuery.useQueryClient)();
  const result = (0, _reactQuery.useMutation)({
    mutationFn: async () => {
      const response = await http.post(`/api/index_management/indices/delete`, {
        body
      });
      return response.acknowledged;
    },
    onSettled: () => {
      queryClient.invalidateQueries([_constants.QueryKeys.FetchIndex, indexName]);
      queryClient.invalidateQueries([_constants.QueryKeys.SearchDocuments, indexName]);
    }
  });
  return {
    ...result
  };
};
exports.useDeleteIndex = useDeleteIndex;