"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicesRedirect = void 0;
var _react = require("react");
var _use_kibana = require("../../../hooks/use_kibana");
var _utils = require("../../utils");
var _usage_tracker_context = require("../../../contexts/usage_tracker_context");
var _constants = require("../../../analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndicesRedirect = (indicesStatus, userPrivileges) => {
  const {
    application,
    http,
    sampleDataIngest
  } = (0, _use_kibana.useKibana)().services;
  const [lastStatus, setLastStatus] = (0, _react.useState)(() => undefined);
  const [hasDoneRedirect, setHasDoneRedirect] = (0, _react.useState)(() => false);
  const usageTracker = (0, _usage_tracker_context.useUsageTracker)();
  return (0, _react.useEffect)(() => {
    var _userPrivileges$privi;
    if (hasDoneRedirect) {
      return;
    }
    if (!userPrivileges) {
      return;
    }
    if ((userPrivileges === null || userPrivileges === void 0 ? void 0 : (_userPrivileges$privi = userPrivileges.privileges) === null || _userPrivileges$privi === void 0 ? void 0 : _userPrivileges$privi.canManageIndex) === false) {
      application.navigateToApp('discover');
      setHasDoneRedirect(true);
      return;
    }
    if (!indicesStatus) {
      return;
    }
    if (indicesStatus.indexNames.length === 0) {
      setLastStatus(indicesStatus);
      return;
    }
    if (lastStatus === undefined && indicesStatus.indexNames.length > 0) {
      application.navigateToApp('elasticsearchIndexManagement');
      setHasDoneRedirect(true);
      return;
    }
    if (indicesStatus.indexNames.length === 1) {
      if (sampleDataIngest !== null && sampleDataIngest !== void 0 && sampleDataIngest.isSampleIndex(indicesStatus.indexNames[0])) {
        return;
      }
      (0, _utils.navigateToIndexDetails)(application, http, indicesStatus.indexNames[0]);
      setHasDoneRedirect(true);
      usageTracker.click(_constants.AnalyticsEvents.startCreateIndexCreatedRedirect);
      return;
    }
    application.navigateToApp('elasticsearchIndexManagement');
    setHasDoneRedirect(true);
  }, [application, http, sampleDataIngest, indicesStatus, lastStatus, setHasDoneRedirect, usageTracker, hasDoneRedirect, userPrivileges]);
};
exports.useIndicesRedirect = useIndicesRedirect;