"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resultField = exports.definitionStyle = exports.ResultHeader = void 0;
var _react = require("@emotion/react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resultField = euiTheme => (0, _react.css)({
  padding: 0,
  borderBottom: `1px solid ${euiTheme.colors.lightShade}`,
  position: 'relative',
  '&:last-child': {
    borderBottom: 'none'
  },
  '> .euiTableRow:hover': {
    backgroundColor: euiTheme.colors.emptyShade
  },
  '> .euiTableRowCell': {
    borderTop: 'none',
    borderBottom: 'none',
    '> .euiTableCellContent': {
      padding: euiTheme.size.s,
      fontFamily: euiTheme.font.familyCode,
      color: euiTheme.colors.mediumShade
    }
  },
  '.denseVectorFieldValue': {
    position: 'absolute',
    right: 0,
    top: euiTheme.size.s,
    // replaced $euiSizeS
    backgroundColor: euiTheme.colors.emptyShade,
    // replaced $euiColorEmptyShade
    padding: `0 ${euiTheme.size.s}`
  }
});
exports.resultField = resultField;
const ResultHeader = exports.ResultHeader = _styled.default.div`
  padding: ${({
  euiTheme
}) => `0 ${euiTheme.size.s} ${euiTheme.size.xs} 0`};
`;
const definitionStyle = exports.definitionStyle = (0, _react.css)({
  textOverflow: 'ellipsis',
  overflow: 'hidden',
  maxWidth: '16rem'
});