"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultFieldValue = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/kbn-search-index-documents/components/result/result_field_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ResultFieldValue = ({
  fieldValue,
  fieldType,
  isExpanded = false
}) => {
  if (isExpanded && fieldType && (['object', 'array', 'nested'].includes(fieldType) || Array.isArray(fieldValue))) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      transparentBackground: true,
      fontSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, fieldValue);
  } else if (_constants.PERMANENTLY_TRUNCATED_FIELDS.includes(fieldType)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "default",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, fieldValue), fieldType === 'dense_vector' && /*#__PURE__*/_react.default.createElement("div", {
      className: 'denseVectorFieldValue',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.searchIndexDocuments.result.value.denseVector.dimLabel', {
      defaultMessage: '{value} dims',
      values: {
        value: JSON.parse(fieldValue).length
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: fieldValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 17
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "copyClipboard",
      onClick: copy,
      "data-test-subj": "copyDenseVector",
      "aria-label": _i18n.i18n.translate('xpack.searchIndexDocuments.result.value.denseVector.copy', {
        defaultMessage: 'Copy vector'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 21
      }
    }))))));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "default",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    }, fieldValue);
  }
};
exports.ResultFieldValue = ResultFieldValue;